/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.SnmpAgentData;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;
import org.ultramonkey.l7.view.CommandExecuter;
import org.ultramonkey.l7.view.L7guiServletBase;

public class SnmpAgentServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public SnmpAgentServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11261 class SnmpAgentServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("SnmpAgentServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11262 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11263 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11264 SnmpAgentServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectPage;
        ExecuteMode mode;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11265 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11266 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41059, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11267 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String str_snmpInterval = request.getParameter("snmp_interval");
        if (str_snmpInterval == null) {
            MessageView error = new MessageView(41060, "l7gui_SnmpAgent", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11268 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        String unit_snmpInterval = request.getParameter("unit_interval");
        if (unit_snmpInterval == null) {
            MessageView error = new MessageView(41061, "l7gui_SnmpAgent", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11269 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        L7guiFramework frameWork = new L7guiFramework();
        SnmpAgentData snmp = frameWork.getSnmpAgentData();
        if (snmp == null) {
            MessageView error = new MessageView(41062, "l7gui_SnmpAgent", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11270 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        boolean validationFlag = this.validationcheck(session, str_snmpInterval, snmp);
        if (!validationFlag) {
            session.setAttribute("inputSnmpAgentData", (Object)snmp);
            session.setAttribute("unit_snmpInterval", (Object)unit_snmpInterval);
            MessageView error = new MessageView(21037, "l7gui_SnmpAgent", "Invalid value.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("snmp.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11271 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (!unit_snmpInterval.equals("ms")) {
            if (unit_snmpInterval.equals("s")) {
                snmp.interval *= 1000;
            } else {
                session.setAttribute("inputSnmpAgentData", (Object)snmp);
                session.setAttribute("unit_snmpInterval", (Object)unit_snmpInterval);
                MessageView error = new MessageView(21038, "l7gui_SnmpAgent", "Invalid value.");
                session.setAttribute("resultMessage", (Object)error);
                response.sendRedirect("snmp.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11272 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
        }
        CommandExecuter thread = new CommandExecuter(session);
        String button_mode = request.getParameter("button");
        if (button_mode == null) {
            MessageView error = new MessageView(41063, "l7gui_SnmpAgent", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11273 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (button_mode.equals("Save")) {
            mode = ExecuteMode.SNMP_INFO_SAVE;
            redirectPage = "snmp_modify_executive.jsp";
        } else if (button_mode.equals("Save + Sync")) {
            mode = ExecuteMode.SNMP_INFO_SAVESYNC;
            redirectPage = "savesync_executive.jsp";
            SessionTransData trans = new SessionTransData();
            trans.sourceURI = "snmp.jsp";
            trans.destURI = "snmp.jsp";
            trans.errorURI = "snmp_modify_fail.jsp";
            session.setAttribute("pageTrans", (Object)trans);
        } else {
            MessageView error = new MessageView(41064, "l7gui_SnmpAgent", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11274 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        try {
            thread.setExecute(mode, snmp);
            thread.start();
        }
        catch (Exception e) {
            MessageView error = new MessageView(41065, "l7gui_SnmpAgent", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11275 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        response.sendRedirect(redirectPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11276 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    private boolean validationcheck(HttpSession session, String str_SnmpInterval, SnmpAgentData snmp) {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("SnmpAgentServlet::validationCheck(HttpSession session, String str_SnmpInterval, SnmpAgentData snmp) in ");
            buf.append("session=(" + session + "), ");
            buf.append("str_SnmpInterval=(" + str_SnmpInterval + "), ");
            buf.append("snmp=(" + snmp + ")");
            this.logger.debug((Object)("11277 " + buf.toString()));
        }
        boolean validationFlag = true;
        int MIN_SNMP_INTERVAL = 1;
        int MAX_SNMP_INTERVAL = 999;
        int int_SnmpInterval = 1;
        if (str_SnmpInterval.length() == 0) {
            session.setAttribute("invalidMessage", (Object)"Required fields.");
            validationFlag = false;
        } else {
            try {
                int_SnmpInterval = Integer.parseInt(str_SnmpInterval);
                if (int_SnmpInterval < MIN_SNMP_INTERVAL || int_SnmpInterval > MAX_SNMP_INTERVAL) {
                    session.setAttribute("invalidMessage", (Object)"Validation error.");
                    validationFlag = false;
                }
            }
            catch (NumberFormatException e) {
                session.setAttribute("invalidMessage", (Object)"Validation error.");
                validationFlag = false;
            }
        }
        snmp.interval = int_SnmpInterval;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("11278 SnmpAgentServlet::validationCheck(HttpSession session, String str_SnmpInterval, SnmpAgentData snmp) out return=" + validationFlag));
        }
        return validationFlag;
    }
}

