<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%

	/*
	 * check session
 	 */
	if (session.isNew()) {
	MessageView error = new MessageView(41330, LogCategorySet.GUI_USER_AUTHENTICATION,
			Message.INVALID_SESSSION);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}

	/*
	 * get command message
	 */
	MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
	String commandMessage = "";
	int commandNumber = 0;
	String commandCategory = "";
	if (commandmessage != null) {
		commandMessage = commandmessage.getMessage();
		commandNumber = commandmessage.getErrno();
		commandCategory = commandmessage.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}
	

	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41331, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	// IP CHECK
	String selfIp = cd.self_ip;
	String otherIp = cd.other_ip;
	
	if ( (selfIp == null) || (otherIp == null) ){
		MessageView error = new MessageView(41332, LogCategorySet.GUI_REDUNDANT,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 		
		
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%= cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico"/>

		<title>Redundance</title>
	</head>


	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>

	<div id="content">

		<h1>Redundance</h1>
		<% if (cd.self_status == ClusterStatus.SINGLE ){
		%>
				<p class="error">Cluster disabled.</p>
		<%	
		}
		else {
		%>
		<fieldset class="">
		<legend>Current Status</legend>
		
			<table class="infotable">
			<tr>
				<th class="center">
				<label for="empty"></label>
				</th>
				<th class="center">
				Self Node
				</th>
				<th class="center">
				Peer Node
				</th>
			</tr>
			<tr>
				<th class="left">
				<label for="nodeStatus">Node Status</label>
				</th>
				<td>
				<%= cd.self_status %>
				</td>
				<td>
				<%= cd.other_status %>
				</td>
			</tr>					
			<tr>
				<th class="left">
				<label for="realIp">Real IP Address</label>
				</th>
				<td>
				<%= selfIp %>
				</td>
				<td>
				<%= otherIp %>
				</td>
			</tr>
			</table>
		</fieldset>
			
		


		<% if ( ( (cd.self_status == ClusterStatus.ACTIVE) || (cd.self_status == ClusterStatus.STANDBY) )
				&& ( (cd.other_status == ClusterStatus.ACTIVE) || (cd.other_status == ClusterStatus.STANDBY) ) ){			
		%>
			<form method="post" action="SoRunServlet">
			<h4>Please push the following button, if you would like to switch over.</h4><br />
			<input type="submit" name="button" value="<%=ButtonMode.SWITCH_OVER %>" onClick="return confirm(switch_over)" />
			</form>
	<%
		}
	}
	%>
	</div>	
	</body>

</html>

