/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.EndPoint;
import org.ultramonkey.l7.controller.GetServ;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.FileNotReadException;
import org.ultramonkey.l7.model.FileNotWriteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectorController
implements Serializable {
    static final long serialVersionUID = 1L;
    private final String l7directord = "/usr/sbin/l7directord";
    protected String filename = "";
    protected String CHECKTIMEOUT_KEY = "checktimeout";
    protected String CHECKINTERVAL_KEY = "checkinterval";
    protected String CHECKCOUNT_KEY = "checkcount";
    protected String FALLBACK_KEY = "fallback";
    protected String AUTORELOAD_KEY = "autoreload";
    protected String EXECUTE_KEY = "execute";
    protected String LOGFILE_KEY = "logfile";
    protected String QUIESCENT_KEY = "quiescent";
    protected String CALLBACK_KEY = "callback";
    protected String NEGOTIATE_TIMEOUT_KEY = "negotiatetimeout";
    protected String SUPERVISED_KEY = "supervised";
    protected String VIRTUAL_KEY = "virtual";
    protected String CHECKTYPE_KEY = "checktype";
    protected String CHECKPORT_KEY = "checkport";
    protected String MAXCONN_KEY = "maxconn";
    protected String MODULE_KEY = "module";
    protected String PROTOCOL_KEY = "protocol";
    protected String QOSCLIENTS_KEY = "qosclients";
    protected String QOSSERVICE_KEY = "qosservice";
    protected String RECEIVE_KEY = "receive";
    protected String SERVICE_KEY = "service";
    protected String REAL_KEY = "real";
    protected String REQUEST_KEY = "request";
    protected String SCHEDULER_KEY = "scheduler";
    protected String SORRYSERVER_KEY = "sorryserver";
    protected String HTTPMETHOD_KEY = "httpmethod";
    protected String VIRTUALHOST_KEY = "virtualhost";
    protected String PASSWORD_KEY = "passwd";
    protected String LOGIN_KEY = "login";
    protected String DATABASE_KEY = "database";
    protected String REALDOWNCALLBACK_KEY = "realdowncallback";
    protected String REALRECOVERCALLBACK_KEY = "realrecovercallback";

    protected Pair<String, String> paseKey(String inLine) {
        if (inLine == null) {
            return null;
        }
        int pos = inLine.indexOf("=");
        if (pos == -1) {
            return new Pair<String, String>(inLine, "");
        }
        String first = inLine.substring(0, pos);
        String second = inLine.substring(pos + 1, inLine.length());
        if (first.indexOf(35) != -1) {
            return new Pair<String, String>("", "");
        }
        if (second.indexOf(35) != -1) {
            pos = second.indexOf(35);
            second = second.substring(0, pos);
        }
        first = first.trim();
        second = second.trim();
        Pair<String, String> pair = new Pair<String, String>(first, second);
        return pair;
    }

    protected boolean serchfile() {
        String confname = "l7directord.cf";
        String confdir1 = "/etc/ha.d/";
        String confdir2 = "/etc/ha.d/conf/";
        String conf = "/etc/ha.d/l7directord.cf";
        File objFile = new File(conf);
        if (!objFile.exists() && !(objFile = new File(conf = "/etc/ha.d/conf/l7directord.cf")).exists()) {
            return false;
        }
        if (!objFile.isFile()) {
            return false;
        }
        this.filename = objFile.getPath();
        return true;
    }

    private static String trimQuote(String s) {
        if (s != null && s.matches("^\".*\"$")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected DirectorData loadFromFile() throws FileNotReadException {
        DirectorData data;
        try {
            String buffer;
            FileReader file = new FileReader(this.filename);
            BufferedReader reader = new BufferedReader(file);
            data = new DirectorData();
            Stack<String> stack = new Stack<String>();
            int position = 0;
            while ((buffer = reader.readLine()) != null) {
                buffer = buffer.replaceAll("\\s+$", "");
                if ((buffer = buffer.replaceAll("\\t", "    ")).length() == 0 || buffer.matches("^\\s*#.*")) continue;
                if (buffer.indexOf(this.VIRTUAL_KEY) == 0) {
                    ++position;
                }
                stack.push(buffer);
            }
            String tmpGlobalLogFile = "";
            String tmpGlobalExecute = "";
            boolean tmpGlobalAutoreaload = false;
            String tmpGlobalCallback = "";
            String tmpGlobalFallback = "";
            String tmpGlobalCheckInterval = "";
            String tmpGlobalCheckTimeOut = "";
            String tmpGlobalCheckCount = "";
            String tmpGlobalNegotiateTimeOut = "";
            String tmpGlobalQuiescent = "";
            String tmpGlobalSupervised = "no";
            String tmpCheckTimeOut = "";
            String tmpCheckCount = "";
            String tmpNegotiateTimeOut = "";
            String tmpQuiescent = "";
            String tmpQosClients = "";
            String tmpQosService = "";
            String tmpSorryServer = "";
            String tmpMaxConn = "";
            String tmpProtocol = "";
            String tmpScheduler = "";
            String tmpReceive = "";
            String tmpRequest = "";
            String tmpService = "";
            String tmpModule = "";
            Vector<String> tmpReal = new Vector<String>();
            String tmpCheckType = "";
            String tmpCheckport = "";
            String tmpHttpMethod = "";
            String tmpVirtualHost = "";
            String tmpPassword = "";
            String tmpLogin = "";
            String tmpDatabase = "";
            String tmpRealDownCallback = "";
            String tmpRealRecoverCallback = "";
            while (!stack.empty()) {
                Pair<String, String> pair;
                buffer = (String)stack.pop();
                if (buffer.indexOf(this.AUTORELOAD_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalAutoreaload = pair.second().indexOf("yes") != -1;
                }
                if (buffer.indexOf(this.CALLBACK_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalCallback = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.CHECKTIMEOUT_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalCheckTimeOut = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.CHECKINTERVAL_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalCheckInterval = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.CHECKCOUNT_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalCheckCount = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.FALLBACK_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalFallback = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.EXECUTE_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalExecute = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.LOGFILE_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalLogFile = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.NEGOTIATE_TIMEOUT_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalNegotiateTimeOut = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.QUIESCENT_KEY) == 0) {
                    pair = this.paseKey(buffer);
                    tmpGlobalQuiescent = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.SUPERVISED_KEY) == 0) {
                    tmpGlobalSupervised = "yes";
                    continue;
                }
                if (buffer.indexOf(this.CHECKTIMEOUT_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpCheckTimeOut = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.CHECKCOUNT_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpCheckCount = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.NEGOTIATE_TIMEOUT_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpNegotiateTimeOut = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.QUIESCENT_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpQuiescent = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.CHECKTYPE_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpCheckType = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.CHECKPORT_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpCheckport = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.MAXCONN_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpMaxConn = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.MODULE_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpModule = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.PROTOCOL_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpProtocol = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.QOSCLIENTS_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpQosClients = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.QOSSERVICE_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpQosService = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.REAL_KEY) >= 4 && buffer.indexOf(this.REALRECOVERCALLBACK_KEY) == -1 && buffer.indexOf(this.REALDOWNCALLBACK_KEY) == -1) {
                    pair = this.paseKey(buffer);
                    String real = pair.second();
                    tmpReal.add(real);
                    continue;
                }
                if (buffer.indexOf(this.RECEIVE_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpReceive = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.REQUEST_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpRequest = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.SCHEDULER_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpScheduler = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.SERVICE_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpService = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.HTTPMETHOD_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpHttpMethod = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.VIRTUALHOST_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpVirtualHost = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.PASSWORD_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpPassword = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.LOGIN_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpLogin = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.DATABASE_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpDatabase = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.SORRYSERVER_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpSorryServer = pair.second();
                    continue;
                }
                if (buffer.indexOf(this.REALDOWNCALLBACK_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpRealDownCallback = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.REALRECOVERCALLBACK_KEY) >= 4) {
                    pair = this.paseKey(buffer);
                    tmpRealRecoverCallback = DirectorController.trimQuote(pair.second());
                    continue;
                }
                if (buffer.indexOf(this.VIRTUAL_KEY) != 0) continue;
                pair = this.paseKey(buffer);
                VirtualSetting vs = new VirtualSetting();
                int pos = pair.second().indexOf(":");
                vs.virtual.host = pair.second().substring(0, pos);
                vs.virtual.port = pair.second().substring(pos + 1, pair.second().length());
                if (!vs.virtual.port.matches("^\\d+$")) {
                    vs.virtual.port = GetServ.byName(vs.virtual.port, "tcp");
                }
                for (String realstr : tmpReal) {
                    pos = realstr.indexOf(":");
                    EndPoint ed = new EndPoint();
                    ed.host = realstr.substring(0, pos);
                    int spacepos = realstr.lastIndexOf(" ");
                    String tmpWeight = "";
                    if (spacepos == -1) {
                        ed.port = realstr.substring(pos + 1, realstr.length());
                    } else {
                        ed.port = realstr.substring(pos + 1, spacepos).replaceAll(" masq", "");
                        tmpWeight = realstr.substring(spacepos + 1, realstr.length());
                    }
                    if (!ed.port.matches("^\\d+$")) {
                        ed.port = GetServ.byName(ed.port, "tcp");
                    }
                    if (tmpWeight.length() != 0) {
                        try {
                            ed.weight = Integer.parseInt(tmpWeight);
                        }
                        catch (NumberFormatException e) {
                            ed.weight = 1;
                        }
                    }
                    vs.real.add(ed);
                }
                vs.checktype = tmpCheckType;
                if (tmpMaxConn.length() != 0) {
                    vs.maxconn = Integer.parseInt(tmpMaxConn);
                }
                if ((pos = tmpModule.indexOf(" ")) != -1) {
                    vs.protomod = tmpModule.substring(0, pos);
                    vs.option = tmpModule.substring(pos + 1, tmpModule.length());
                } else {
                    vs.protomod = tmpModule;
                    vs.option = "";
                }
                vs.protocol = tmpProtocol;
                if (tmpQosClients.length() != 0) {
                    pos = tmpQosClients.indexOf(107);
                    if (pos != -1 || (pos = tmpQosClients.indexOf(75)) != -1) {
                        vs.qosclient = Long.parseLong(tmpQosClients.substring(0, pos));
                        vs.qosclient *= 1000L;
                    } else {
                        pos = tmpQosClients.indexOf(77);
                        if (pos != -1 || (pos = tmpQosClients.indexOf(109)) != -1) {
                            vs.qosclient = Long.parseLong(tmpQosClients.substring(0, pos));
                            vs.qosclient *= 1000000L;
                        } else {
                            vs.qosclient = Long.parseLong(tmpQosClients);
                        }
                    }
                }
                if (tmpQosService.length() != 0) {
                    pos = tmpQosService.indexOf(75);
                    if (pos != -1 || (pos = tmpQosService.indexOf(107)) != -1) {
                        vs.qosservice = Long.parseLong(tmpQosService.substring(0, pos));
                        vs.qosservice *= 1000L;
                    } else {
                        pos = tmpQosService.indexOf(77);
                        if (pos != -1 || (pos = tmpQosService.indexOf(109)) != -1) {
                            vs.qosservice = Long.parseLong(tmpQosService.substring(0, pos));
                            vs.qosservice *= 1000000L;
                        } else {
                            vs.qosservice = Long.parseLong(tmpQosService);
                        }
                    }
                }
                vs.receive = tmpReceive;
                vs.service = tmpService;
                vs.request = tmpRequest;
                vs.sched = tmpScheduler;
                pos = tmpSorryServer.indexOf(":");
                if (pos != -1) {
                    vs.sorryserver.host = tmpSorryServer.substring(0, pos);
                    vs.sorryserver.port = tmpSorryServer.substring(pos + 1, tmpSorryServer.length());
                    if (!vs.sorryserver.port.matches("^\\d+$")) {
                        vs.sorryserver.port = GetServ.byName(vs.sorryserver.port, "tcp");
                    }
                }
                vs.quiescent = tmpQuiescent;
                vs.upcallback = tmpRealRecoverCallback;
                vs.downcallback = tmpRealDownCallback;
                if (tmpCheckport.length() != 0) {
                    vs.checkport = Integer.parseInt(tmpCheckport);
                }
                vs.httpmethod = tmpHttpMethod;
                vs.virtualhost = tmpVirtualHost;
                vs.login = tmpLogin;
                vs.database = tmpDatabase;
                vs.passwd = tmpPassword;
                if (tmpCheckType != null && (tmpCheckType.equals("connect") || tmpCheckType.equals("ping") || (tmpCheckType.equals("negotiate") || tmpCheckType.matches("^\\d$")) && tmpService != null && (tmpService.equals("dns") || tmpService.equals("sip")))) {
                    if (tmpCheckTimeOut.matches("^\\d+$")) {
                        vs.timeout = Integer.parseInt(tmpCheckTimeOut);
                    }
                } else if (tmpNegotiateTimeOut.matches("^\\d+$")) {
                    vs.timeout = Integer.parseInt(tmpNegotiateTimeOut);
                }
                if (tmpCheckCount.matches("^\\d+$")) {
                    vs.checkcount = Integer.parseInt(tmpCheckCount);
                }
                vs.cfPosition = position--;
                data.virtualSettings.add(vs);
                tmpCheckTimeOut = "";
                tmpCheckCount = "";
                tmpNegotiateTimeOut = "";
                tmpQuiescent = "";
                tmpQosClients = "";
                tmpQosService = "";
                tmpSorryServer = "";
                tmpMaxConn = "";
                tmpProtocol = "";
                tmpScheduler = "";
                tmpReceive = "";
                tmpRequest = "";
                tmpService = "";
                tmpModule = "";
                tmpReal = new Vector();
                tmpCheckType = "";
                tmpCheckport = "";
                tmpHttpMethod = "";
                tmpVirtualHost = "";
                tmpPassword = "";
                tmpLogin = "";
                tmpDatabase = "";
                tmpRealDownCallback = "";
                tmpRealRecoverCallback = "";
            }
            data.autoreload = tmpGlobalAutoreaload;
            data.callback = tmpGlobalCallback;
            data.checkCount = tmpGlobalCheckCount;
            data.checkInterval = tmpGlobalCheckInterval;
            data.checkTimeOut = tmpGlobalCheckTimeOut;
            data.fallback = tmpGlobalFallback;
            data.logfile = tmpGlobalLogFile;
            data.execute = tmpGlobalExecute;
            data.negotiateTimeOut = tmpGlobalNegotiateTimeOut;
            data.quiescent = tmpGlobalQuiescent;
            data.supervised = tmpGlobalSupervised;
        }
        catch (Exception e) {
            FileNotReadException ex = new FileNotReadException();
            throw ex;
        }
        return data;
    }

    protected LinkedList<String> buildNewConf(DirectorData in) throws FileNotWriteException {
        LinkedList<String> datas = new LinkedList<String>();
        try {
            String buffer;
            FileReader file = new FileReader(this.filename);
            BufferedReader reader = new BufferedReader(file);
            while ((buffer = reader.readLine()) != null) {
                datas.addLast(buffer);
            }
        }
        catch (Exception e) {
            FileNotWriteException ex = new FileNotWriteException();
            ex.setErrMessage("Cannot open file : " + this.filename);
            throw ex;
        }
        try {
            StringBuffer buf;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.CHECKTIMEOUT_KEY, in.checkTimeOut);
            map.put(this.CHECKINTERVAL_KEY, in.checkInterval);
            map.put(this.CHECKCOUNT_KEY, in.checkCount);
            map.put(this.FALLBACK_KEY, in.fallback);
            if (in.autoreload) {
                map.put(this.AUTORELOAD_KEY, "yes");
            } else {
                map.put(this.AUTORELOAD_KEY, "no");
            }
            if (in.logfile != null && in.logfile.length() > 0) {
                map.put(this.LOGFILE_KEY, "\"" + in.logfile + "\"");
            } else {
                map.put(this.LOGFILE_KEY, null);
            }
            if (in.execute != null && in.execute.length() > 0) {
                map.put(this.EXECUTE_KEY, "\"" + in.execute + "\"");
            } else {
                map.put(this.EXECUTE_KEY, null);
            }
            map.put(this.QUIESCENT_KEY, in.quiescent);
            if (in.callback != null && in.callback.length() > 0) {
                map.put(this.CALLBACK_KEY, "\"" + in.callback + "\"");
            } else {
                map.put(this.CALLBACK_KEY, null);
            }
            map.put(this.NEGOTIATE_TIMEOUT_KEY, in.negotiateTimeOut);
            if (in.supervised != null && in.supervised.equals("yes")) {
                map.put(this.SUPERVISED_KEY, in.supervised);
            } else {
                map.put(this.SUPERVISED_KEY, null);
            }
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                int commentLines = 0;
                boolean inserted = false;
                int i = 0;
                while (i < datas.size()) {
                    String line = (String)datas.get(i);
                    String buffer = line.replaceAll("\\s+$", "");
                    if (buffer.length() == 0 || buffer.matches("^\\s*#.*")) {
                        ++commentLines;
                    } else {
                        if (buffer.indexOf(this.VIRTUAL_KEY) == 0) {
                            if (value != null && value.length() > 0) {
                                StringBuffer buf2 = new StringBuffer(key);
                                if (!key.equals(this.SUPERVISED_KEY)) {
                                    buf2.append("=");
                                    buf2.append(value);
                                }
                                datas.add(i - commentLines, buf2.toString());
                            }
                            inserted = true;
                            break;
                        }
                        commentLines = 0;
                        Pair<String, String> pair = this.paseKey(buffer);
                        if (pair.first().equals(key)) {
                            if (value == null || !pair.second().equals(value)) {
                                buf = new StringBuffer("#");
                                buf.append(buffer);
                                datas.set(i, buf.toString());
                                if (value != null && value.length() > 0) {
                                    buf = new StringBuffer();
                                    buf.append(key);
                                    if (!key.equals(this.SUPERVISED_KEY)) {
                                        buf.append("=");
                                        buf.append(value);
                                    }
                                    datas.add(i, buf.toString());
                                }
                            }
                            inserted = true;
                            break;
                        }
                    }
                    ++i;
                }
                if (inserted || value == null || value.length() <= 0) continue;
                StringBuffer buf3 = new StringBuffer(key);
                if (!key.equals(this.SUPERVISED_KEY)) {
                    buf3.append("=");
                    buf3.append(value);
                }
                datas.add(buf3.toString());
            }
            DirectorData currentData = null;
            currentData = this.loadFromFile();
            LinkedList<Integer> delVsPosition = new LinkedList<Integer>();
            LinkedList<VirtualSetting> addVs = new LinkedList<VirtualSetting>();
            for (VirtualSetting vs : in.virtualSettings) {
                boolean sameFlag = false;
                for (VirtualSetting curVs : currentData.virtualSettings) {
                    if (!curVs.equals(vs)) continue;
                    sameFlag = true;
                    curVs.cfPosition = 0;
                    break;
                }
                if (sameFlag) continue;
                addVs.add(vs);
            }
            for (VirtualSetting curVs : currentData.virtualSettings) {
                if (curVs.cfPosition == 0) continue;
                delVsPosition.add(curVs.cfPosition);
            }
            int position = 0;
            int commentLines = 0;
            int i = 0;
            while (i < datas.size()) {
                String buffer = (String)datas.get(i);
                String line = buffer.replaceAll("\\s+$", "");
                if (line.length() != 0 && !line.matches("^\\s*#.*") && buffer.indexOf(this.VIRTUAL_KEY) == 0 && delVsPosition.contains(++position)) {
                    int vsStartLine = i;
                    while (i < datas.size()) {
                        buffer = datas.get(i);
                        line = buffer.replaceAll("\\s+$", "");
                        if (line.length() == 0 || line.matches("^\\s*#.*")) {
                            ++commentLines;
                        } else {
                            if (buffer.indexOf(this.VIRTUAL_KEY) == 0 && i != vsStartLine) {
                                i -= 1 + commentLines;
                                commentLines = 0;
                                break;
                            }
                            commentLines = 0;
                            buf = new StringBuffer("#");
                            buf.append(datas.get(i));
                            datas.set(i, buf.toString());
                        }
                        ++i;
                    }
                }
                ++i;
            }
            for (VirtualSetting vs : addVs) {
                StringBuffer buf4;
                datas.add(String.valueOf(this.VIRTUAL_KEY) + "=" + vs.virtual.host + ":" + vs.virtual.port);
                if (vs.real.size() != 0) {
                    for (EndPoint endpoint : vs.real) {
                        datas.add("\t" + this.REAL_KEY + "=" + endpoint.host + ":" + endpoint.port + " masq " + String.valueOf(endpoint.weight));
                    }
                }
                if (vs.checktype.length() != 0) {
                    datas.add("\t" + this.CHECKTYPE_KEY + "=" + vs.checktype);
                }
                if (vs.checkport != 0) {
                    datas.add("\t" + this.CHECKPORT_KEY + "=" + vs.checkport);
                }
                if (vs.maxconn != 0) {
                    datas.add("\t" + this.MAXCONN_KEY + "=" + String.valueOf(vs.maxconn));
                }
                if (vs.protomod.length() != 0) {
                    datas.add("\t" + this.MODULE_KEY + "=" + vs.protomod + " " + vs.option);
                }
                if (vs.qosclient != 0L) {
                    buf4 = new StringBuffer();
                    if (vs.qosclient > 1000000L) {
                        buf4.append(vs.qosclient / 1000000L);
                        buf4.append('M');
                    } else if (vs.qosclient > 1000L) {
                        buf4.append(vs.qosclient / 1000L);
                        buf4.append('K');
                    } else {
                        buf4.append(vs.qosclient);
                    }
                    datas.add("\t" + this.QOSCLIENTS_KEY + "=" + buf4.toString());
                }
                if (vs.qosservice != 0L) {
                    buf4 = new StringBuffer();
                    if (vs.qosservice > 1000000L) {
                        buf4.append(vs.qosservice / 1000000L);
                        buf4.append('M');
                    } else if (vs.qosservice > 1000L) {
                        buf4.append(vs.qosservice / 1000L);
                        buf4.append('K');
                    } else {
                        buf4.append(vs.qosservice);
                    }
                    datas.add("\t" + this.QOSSERVICE_KEY + "=" + buf4.toString());
                }
                if (vs.receive.length() != 0) {
                    datas.add("\t" + this.RECEIVE_KEY + "=\"" + vs.receive + "\"");
                }
                if (vs.service.length() != 0) {
                    datas.add("\t" + this.SERVICE_KEY + "=\"" + vs.service + "\"");
                }
                if (vs.request.length() != 0) {
                    datas.add("\t" + this.REQUEST_KEY + "=\"" + vs.request + "\"");
                }
                if (vs.sched.length() != 0) {
                    datas.add("\t" + this.SCHEDULER_KEY + "=" + vs.sched);
                }
                if (vs.sorryserver.host.length() != 0) {
                    datas.add("\t" + this.SORRYSERVER_KEY + "=" + vs.sorryserver.host + ":" + vs.sorryserver.port);
                }
                if (vs.httpmethod.length() != 0) {
                    datas.add("\t" + this.HTTPMETHOD_KEY + "=" + vs.httpmethod);
                }
                if (vs.virtualhost.length() != 0) {
                    datas.add("\t" + this.VIRTUALHOST_KEY + "=\"" + vs.virtualhost + "\"");
                }
                if (vs.passwd.length() != 0) {
                    datas.add("\t" + this.PASSWORD_KEY + "=\"" + vs.passwd + "\"");
                }
                if (vs.login.length() != 0) {
                    datas.add("\t" + this.LOGIN_KEY + "=\"" + vs.login + "\"");
                }
                if (vs.database.length() != 0) {
                    datas.add("\t" + this.DATABASE_KEY + "=\"" + vs.database + "\"");
                }
                if (vs.downcallback.length() != 0) {
                    datas.add("\t" + this.REALDOWNCALLBACK_KEY + "=\"" + vs.downcallback + "\"");
                }
                if (vs.upcallback.length() != 0) {
                    datas.add("\t" + this.REALRECOVERCALLBACK_KEY + "=\"" + vs.upcallback + "\"");
                }
                if (vs.timeout != 0) {
                    if (vs.checktype != null && (vs.checktype.equals("connect") || vs.checktype.equals("ping") || (vs.checktype.equals("negotiate") || vs.checktype.matches("^\\d$")) && vs.service != null && (vs.service.equals("dns") || vs.service.equals("sip")))) {
                        datas.add("\t" + this.CHECKTIMEOUT_KEY + "=" + vs.timeout);
                    } else {
                        datas.add("\t" + this.NEGOTIATE_TIMEOUT_KEY + "=" + vs.timeout);
                    }
                }
                if (vs.quiescent.length() != 0) {
                    datas.add("\t" + this.QUIESCENT_KEY + "=" + vs.quiescent);
                }
                if (vs.protocol.length() != 0) {
                    datas.add("\t" + this.PROTOCOL_KEY + "=" + vs.protocol);
                }
                datas.add("");
            }
        }
        catch (Exception e) {
            FileNotWriteException ex = new FileNotWriteException();
            ex.setErrMessage("Cannot open file : " + this.filename + "BaseException : " + e.getMessage());
            throw ex;
        }
        return datas;
    }

    protected void saveToFile(DirectorData in) throws FileNotWriteException {
        LinkedList<String> datas = this.buildNewConf(in);
        try {
            File file = new File(this.filename);
            if (file.exists()) {
                Date date = new Date();
                File backfile = new File(String.valueOf(this.filename) + ".bak." + String.valueOf(date.getTime()));
                file.renameTo(backfile);
                file = new File(this.filename);
            }
            FileWriter writer = new FileWriter(file);
            Iterator itr = datas.iterator();
            while (itr.hasNext()) {
                StringBuffer buf = new StringBuffer((String)itr.next());
                buf.append('\n');
                writer.write(buf.toString());
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            FileNotWriteException ex = new FileNotWriteException();
            ex.setErrMessage("Cannot write file : " + this.filename);
            throw ex;
        }
    }

    protected String syntaxCheck(DirectorData in) throws FileNotWriteException {
        StringBuffer result = new StringBuffer();
        LinkedList<String> datas = this.buildNewConf(in);
        try {
            Date date = new Date();
            String tmpFile = String.valueOf(this.filename) + "." + String.valueOf(date.getTime());
            File file = new File(tmpFile);
            FileWriter writer = new FileWriter(file);
            Iterator itr = datas.iterator();
            while (itr.hasNext()) {
                StringBuffer buf = new StringBuffer((String)itr.next());
                buf.append('\n');
                writer.write(buf.toString());
            }
            writer.flush();
            writer.close();
            String command = "sudo /usr/sbin/l7directord -t " + tmpFile;
            Process p = Runtime.getRuntime().exec(command);
            InputStream stderr = p.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(stderr));
            String line = null;
            while ((line = br.readLine()) != null) {
                result.append(String.valueOf(line) + "\n");
            }
            InputStream is = p.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                result.append(String.valueOf(line) + "\n");
            }
            file.delete();
        }
        catch (Exception e) {
            FileNotWriteException ex = new FileNotWriteException();
            ex.setErrMessage("Cannot write file : " + this.filename);
            throw ex;
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectorData getDirectorData() throws FileNotReadException {
        Logger ioFileLogger = Logger.getLogger((String)"l7gui_I/O.File");
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug((Object)"11575 DirectorController::getDirectorData() in");
        }
        DirectorData data = null;
        DirectorController directorController = this;
        synchronized (directorController) {
            if (this.serchfile()) {
                data = this.loadFromFile();
            }
        }
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug((Object)("11576 DirectorController::getDirectorData() out return=(" + data + ")"));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectorData(DirectorData in) throws FileNotWriteException {
        Logger ioFileLogger = Logger.getLogger((String)"l7gui_I/O.File");
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug((Object)("11577 DirectorController::setDirectorData(DirectorData in) in in=(" + in + ")"));
        }
        DirectorController directorController = this;
        synchronized (directorController) {
            if (in != null && this.serchfile()) {
                this.saveToFile(in);
            }
        }
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug((Object)"11578 DirectorController::setDirectorData(DirectorData in) out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkDirectorData(DirectorData in) throws FileNotWriteException {
        Logger ioFileLogger = Logger.getLogger((String)"l7gui_I/O.File");
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug((Object)("11579 DirectorController::checkDirectorData(DirectorData in) in in=(" + in + ")"));
        }
        DirectorController directorController = this;
        synchronized (directorController) {
            if (in != null && this.serchfile()) {
                String ret = this.syntaxCheck(in);
                if (ioFileLogger.isDebugEnabled()) {
                    ioFileLogger.debug((Object)("11580 DirectorController::checkDirectorData(DirectorData in) out return=\"" + ret + "\""));
                }
                return ret;
            }
            if (ioFileLogger.isDebugEnabled()) {
                ioFileLogger.debug((Object)"11581 DirectorController::checkDirectorData(DirectorData in) out return=null");
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pair<E, N> {
        protected E elementFirst;
        protected N elementSecond;

        public Pair(E firstIn, N secondIn) {
            this.elementFirst = firstIn;
            this.elementSecond = secondIn;
        }

        public void set(E firstIn, N secondIn) {
            this.elementFirst = firstIn;
            this.elementSecond = secondIn;
        }

        public E first() {
            return this.elementFirst;
        }

        public N second() {
            return this.elementSecond;
        }
    }
}

