
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class StringUtil {

    private StringUtil() {
    }

    public static String hash(String data) {
        if (data == null) {
            return null;
        }

        StringBuilder hashText = new StringBuilder();

        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-512");
        } catch (NoSuchAlgorithmException e) {
            return null;
        }

        byte[] hashData = md.digest(data.getBytes());
        for (int i = 0; i < hashData.length; i++) {
            hashText.append(Integer.toHexString((hashData[i] >> 4) & 0x0f));
            hashText.append(Integer.toHexString(hashData[i] & 0x0f));
        }

        return hashText.toString();
    }

}
