
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.service;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListItemModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListRepositoryModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.service.ListRepositoryService;
import jp.gr.java_conf.u6k.simple_checklist.gwt.server.logic.ListRepositoryLogic;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

@SuppressWarnings("serial")
public class ListRepositoryServiceImpl extends RemoteServiceServlet implements ListRepositoryService {

    private static final Logger log = Logger.getLogger(ListRepositoryServiceImpl.class.getName());

    @Override
    public ListRepositoryModelData createListRepository() {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            ListRepositoryModelData listRepositoryData = listRepositoryLogic.createListRepository();

            return listRepositoryData;
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

    @Override
    public ListItemModelData createListItem(long listRepositoryId, ListItemModelData listItemData) {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            ListItemModelData newListItemData = listRepositoryLogic.createListItem(listRepositoryId, listItemData);

            return newListItemData;
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

    @Override
    public ListRepositoryModelData updateListRepository(ListRepositoryModelData listRepositoryData) {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            ListRepositoryModelData updatedListRepositoryData = listRepositoryLogic.updateListRepository(listRepositoryData);

            return updatedListRepositoryData;
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

    @Override
    public List<ListItemModelData> updateListItem(List<ListItemModelData> listItemDataList) {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            List<ListItemModelData> updatedListItemDataList = listRepositoryLogic.updateListItem(listItemDataList);

            return updatedListItemDataList;
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

    @Override
    public void deleteListItem(List<ListItemModelData> listItemDataList) {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            listRepositoryLogic.deleteListItem(listItemDataList);
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

    @Override
    public ListRepositoryModelData findListRepositoryByListRepositoryId(long listRepositoryId) {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            ListRepositoryModelData listRepositoryData = listRepositoryLogic.findListRepositoryByListRepositoryId(listRepositoryId);

            return listRepositoryData;
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

    @Override
    public List<ListItemModelData> findListItemByListRepositoryId(long listRepositoryId) {
        try {
            ListRepositoryLogic listRepositoryLogic = new ListRepositoryLogic();
            List<ListItemModelData> listItemDataList = listRepositoryLogic.findListItemByListRepositoryId(listRepositoryId);

            return listItemDataList;
        } catch (RuntimeException e) {
            ListRepositoryServiceImpl.log.log(Level.SEVERE, null, e);

            throw e;
        }
    }

}
