
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.logic;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityManager;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.exception.ListRepositoryNotFoundException;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListItemModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListRepositoryModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity.EntityUtil;
import jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity.ListItemDao;
import jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity.ListItemEntity;
import jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity.ListRepositoryDao;
import jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity.ListRepositoryEntity;

public class ListRepositoryLogic {

    public ListRepositoryModelData createListRepository() {
        ListRepositoryModelData listRepositoryData;

        EntityManager em = EntityUtil.createEntityManager();
        try {
            em.getTransaction().begin();

            // リスト・リポジトリを作成する。
            ListRepositoryDao listRepositoryDao = new ListRepositoryDao(em);
            ListRepositoryEntity listRepositoryEntity = listRepositoryDao.create();

            // 戻り値を構築する。
            listRepositoryData = new ListRepositoryModelData();
            listRepositoryData.setEntityVersion(listRepositoryEntity.getEntityVersion());
            listRepositoryData.setEntityCreateDatetime(listRepositoryEntity.getEntityCreateDatetime());
            listRepositoryData.setId(listRepositoryEntity.getId());
            listRepositoryData.setName(listRepositoryEntity.getName());

            em.getTransaction().commit();
        } finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }

            em.close();
        }

        return listRepositoryData;
    }

    public ListItemModelData createListItem(long listRepositoryId, ListItemModelData listItemData) {
        // 引数を検証する。
        if (listItemData == null) {
            throw new IllegalArgumentException("listItemData == null");
        }

        EntityManager em = EntityUtil.createEntityManager();
        try {
            em.getTransaction().begin();

            // リスト・アイテムの親であるリスト・リポジトリを検索する。
            ListRepositoryDao listRepositoryDao = new ListRepositoryDao(em);
            ListRepositoryEntity listRepositoryEntity = listRepositoryDao.findById(listRepositoryId);

            if (listRepositoryEntity == null) {
                throw new ListRepositoryNotFoundException(String.format("id: %s", listRepositoryId));
            }

            // リスト・アイテムを作成する。
            ListItemDao listItemDao = new ListItemDao(em);
            ListItemEntity listItemEntity = listItemDao.create(listRepositoryEntity, listItemData.getContent());

            em.getTransaction().commit();

            // 戻り値を構築して、戻す。
            ListItemModelData newListItemData = new ListItemModelData();
            newListItemData.setEntityVersion(listItemEntity.getEntityVersion());
            newListItemData.setEntityCreateDatetime(listItemEntity.getEntityCreateDatetime());
            newListItemData.setId(listItemEntity.getId());
            newListItemData.setContent(listItemEntity.getContent());
            newListItemData.setItemState(listItemEntity.getItemState());

            return newListItemData;
        } finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }

            em.close();
        }
    }

    public ListRepositoryModelData updateListRepository(ListRepositoryModelData listRepositoryData) {
        // 引数を検証する。
        if (listRepositoryData == null) {
            throw new IllegalArgumentException("listRepositoryData == null");
        }

        ListRepositoryModelData updatedListRepositoryData;

        EntityManager em = EntityUtil.createEntityManager();
        try {
            em.getTransaction().begin();

            // リスト・リポジトリを更新する。
            ListRepositoryDao listRepositoryDao = new ListRepositoryDao(em);
            ListRepositoryEntity updatedListRepositoryEntity = listRepositoryDao.update(listRepositoryData.getEntityVersion(), listRepositoryData.getId(), listRepositoryData.getName());

            // 戻り値を構築する。
            updatedListRepositoryData = new ListRepositoryModelData();
            updatedListRepositoryData.setEntityVersion(updatedListRepositoryEntity.getEntityVersion());
            updatedListRepositoryData.setEntityCreateDatetime(updatedListRepositoryEntity.getEntityCreateDatetime());
            updatedListRepositoryData.setId(updatedListRepositoryEntity.getId());
            updatedListRepositoryData.setName(updatedListRepositoryEntity.getName());

            em.getTransaction().commit();
        } finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }

            em.close();
        }

        return updatedListRepositoryData;
    }

    public List<ListItemModelData> updateListItem(List<ListItemModelData> listItemDataList) {
        // 引数を検証する。
        if (listItemDataList == null) {
            throw new IllegalArgumentException("listItemDataList == null");
        }

        for (int i = 0; i < listItemDataList.size(); i++) {
            if (listItemDataList.get(i) == null) {
                throw new IllegalArgumentException(String.format("listItemDataList[%s] == null", i));
            }
        }

        List<ListItemModelData> updatedListItemDataList = new ArrayList<ListItemModelData>();

        EntityManager em = EntityUtil.createEntityManager();
        try {
            em.getTransaction().begin();

            // リスト・アイテムを列挙して、更新、及び戻り値の構築を行う。
            ListItemDao listItemDao = new ListItemDao(em);

            for (ListItemModelData listItemData : listItemDataList) {
                // 更新する。
                ListItemEntity updatedListItemEntity = listItemDao.update(listItemData.getEntityVersion(), listItemData.getId(), listItemData.getContent(), listItemData.getItemState());

                // 戻り値を構築する。
                ListItemModelData updatedListItemData = new ListItemModelData();
                updatedListItemData.setEntityVersion(updatedListItemEntity.getEntityVersion());
                updatedListItemData.setEntityCreateDatetime(updatedListItemEntity.getEntityCreateDatetime());
                updatedListItemData.setId(updatedListItemEntity.getId());
                updatedListItemData.setContent(updatedListItemEntity.getContent());
                updatedListItemData.setItemState(updatedListItemEntity.getItemState());

                updatedListItemDataList.add(updatedListItemData);
            }

            em.getTransaction().commit();
        } finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }

            em.close();
        }

        return updatedListItemDataList;
    }

    public void deleteListItem(List<ListItemModelData> listItemDataList) {
        // 引数を検証する。
        if (listItemDataList == null) {
            throw new IllegalArgumentException("listItemDataList == null");
        }

        for (int i = 0; i < listItemDataList.size(); i++) {
            if (listItemDataList.get(i) == null) {
                throw new IllegalArgumentException(String.format("listItemDataList[%s] == null"));
            }
        }

        EntityManager em = EntityUtil.createEntityManager();
        try {
            em.getTransaction().begin();

            // リスト・アイテムを列挙して、削除する。
            ListItemDao listItemDao = new ListItemDao(em);

            for (ListItemModelData listItemData : listItemDataList) {
                listItemDao.delete(listItemData.getEntityVersion(), listItemData.getId());
            }

            em.getTransaction().commit();
        } finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }

            em.close();
        }
    }

    public ListRepositoryModelData findListRepositoryByListRepositoryId(long listRepositoryId) {
        ListRepositoryModelData listRepositoryData;

        EntityManager em = EntityUtil.createEntityManager();
        try {
            // リスト・リポジトリを検索する。
            ListRepositoryDao listRepositoryDao = new ListRepositoryDao(em);
            ListRepositoryEntity listRepositoryEntity = listRepositoryDao.findById(listRepositoryId);

            if (listRepositoryEntity == null) {
                throw new ListRepositoryNotFoundException(String.format("id: %s", listRepositoryId));
            }

            // 戻り値を構築する。
            listRepositoryData = new ListRepositoryModelData();
            listRepositoryData.setEntityVersion(listRepositoryEntity.getEntityVersion());
            listRepositoryData.setEntityCreateDatetime(listRepositoryEntity.getEntityCreateDatetime());
            listRepositoryData.setId(listRepositoryEntity.getId());
            listRepositoryData.setName(listRepositoryEntity.getName());
        } finally {
            em.close();
        }

        return listRepositoryData;
    }

    public List<ListItemModelData> findListItemByListRepositoryId(long listRepositoryId) {
        List<ListItemModelData> listItemDataList = new ArrayList<ListItemModelData>();

        EntityManager em = EntityUtil.createEntityManager();
        try {
            // まず、リスト・リポジトリを検索する。
            ListRepositoryDao listRepositoryDao = new ListRepositoryDao(em);
            ListRepositoryEntity listRepositoryEntity = listRepositoryDao.findById(listRepositoryId);

            if (listRepositoryEntity == null) {
                throw new ListRepositoryNotFoundException(String.format("id: %s", listRepositoryId));
            }

            // リスト・アイテムを検索する。
            ListItemDao listItemDao = new ListItemDao(em);
            List<ListItemEntity> listItemEntityList = listItemDao.findByListRepository(listRepositoryEntity);

            // 戻り値を構築する。
            for (ListItemEntity listItemEntity : listItemEntityList) {
                ListItemModelData listItemData = new ListItemModelData();
                listItemData.setEntityVersion(listItemEntity.getEntityVersion());
                listItemData.setEntityCreateDatetime(listItemEntity.getEntityCreateDatetime());
                listItemData.setId(listItemEntity.getId());
                listItemData.setContent(listItemEntity.getContent());
                listItemData.setItemState(listItemEntity.getItemState());

                listItemDataList.add(listItemData);
            }
        } finally {
            em.close();
        }

        return listItemDataList;
    }

}
