
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import com.google.appengine.api.datastore.Key;

@Entity
public class ListRepositoryEntity {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Key key;

    @Version
    private long version;

    private long entityVersion;

    @Temporal(TemporalType.TIMESTAMP)
    private Date entityCreateDatetime;

    private EntityStateEnum entityState;

    private long id;

    private String name;

    @OneToMany(mappedBy = "listRepository")
    private List<ListItemEntity> listItemList;

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    public void setEntityVersion(long entityVersion) {
        this.entityVersion = entityVersion;
    }

    public Date getEntityCreateDatetime() {
        return this.entityCreateDatetime;
    }

    public void setEntityCreateDatetime(Date entityCreateDatetime) {
        this.entityCreateDatetime = entityCreateDatetime;
    }

    public EntityStateEnum getEntityState() {
        return this.entityState;
    }

    public void setEntityState(EntityStateEnum entityState) {
        this.entityState = entityState;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ListItemEntity> getListItemList() {
        return this.listItemList;
    }

    public void setListItemList(List<ListItemEntity> listItemList) {
        this.listItemList = listItemList;
    }

}
