
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.exception.ListRepositoryNotFoundException;

public class ListRepositoryDao {

    private EntityManager em;

    public ListRepositoryDao(EntityManager em) {
        this.em = em;
    }

    public ListRepositoryEntity create() {
        // リスト・リポジトリを作成する。
        long id = this.getLastId() + 1;
        String name = "第" + id + "リスト";

        ListRepositoryEntity entity = new ListRepositoryEntity();
        entity.setEntityVersion(1);
        entity.setEntityCreateDatetime(new Date());
        entity.setEntityState(EntityStateEnum.LATEST);
        entity.setId(id);
        entity.setName(name);

        this.em.persist(entity);

        // 作成したリスト・リポジトリを戻す。
        return entity;
    }

    public ListRepositoryEntity update(long entityVersion, long id, String name) {
        // 最新エンティティを旧エンティティに更新する。
        ListRepositoryEntity oldEntity = this.find(entityVersion, id);
        if (oldEntity == null) {
            throw new ListRepositoryNotFoundException(String.format("entityVersion: %s, id: %s", entityVersion, id));
        }

        oldEntity.setEntityState(EntityStateEnum.OLD);

        this.em.persist(oldEntity);

        // リスト・リポジトリを作成する。
        ListRepositoryEntity entity = new ListRepositoryEntity();
        entity.setEntityVersion(oldEntity.getEntityVersion() + 1);
        entity.setEntityCreateDatetime(new Date());
        entity.setEntityState(EntityStateEnum.LATEST);
        entity.setId(oldEntity.getId());
        entity.setName(name);

        this.em.persist(entity);

        // 作成したリスト・リポジトリを戻す。
        return entity;
    }

    public void delete(long entityVersion, long id) {
        // 最新エンティティを旧エンティティに更新する。
        ListRepositoryEntity oldEntity = this.find(entityVersion, id);
        if (oldEntity == null) {
            throw new ListRepositoryNotFoundException(String.format("entityVersion: %s, id: %s", entityVersion, id));
        }

        oldEntity.setEntityState(EntityStateEnum.OLD);

        this.em.persist(oldEntity);

        // リスト・リポジトリを作成する。
        ListRepositoryEntity entity = new ListRepositoryEntity();
        entity.setEntityVersion(oldEntity.getEntityVersion() + 1);
        entity.setEntityCreateDatetime(new Date());
        entity.setEntityState(EntityStateEnum.DELETE);
        entity.setId(oldEntity.getId());
        entity.setName(oldEntity.getName());

        this.em.persist(entity);
    }

    public ListRepositoryEntity find(long entityVersion, long id) {
        // リスト・リポジトリを検索して戻す。
        String queryString = "select e from " + ListRepositoryEntity.class.getName() + " e";
        queryString += " where entityVersion = :entityVersion";
        queryString += " and entityState = :entityState";
        queryString += " and id = :id";

        Query query = this.em.createQuery(queryString);
        query.setParameter("entityVersion", entityVersion);
        query.setParameter("entityState", EntityStateEnum.LATEST);
        query.setParameter("id", id);

        ListRepositoryEntity entity = EntityUtil.getSingleResult(query);

        return entity;
    }

    public ListRepositoryEntity findById(long id) {
        // リスト・リポジトリを検索して戻す。
        String queryString = "select e from " + ListRepositoryEntity.class.getName() + " e";
        queryString += " where entityState = :entityState";
        queryString += " and id = :id";

        Query query = this.em.createQuery(queryString);
        query.setParameter("entityState", EntityStateEnum.LATEST);
        query.setParameter("id", id);

        ListRepositoryEntity entity = EntityUtil.getSingleResult(query);

        return entity;
    }

    public long getLastId() {
        // リスト・リポジトリをIDの大きい順に検索する。
        String queryString = "select e from " + ListRepositoryEntity.class.getName() + " e";
        queryString += " order by id desc";

        Query query = this.em.createQuery(queryString);

        List<ListRepositoryEntity> list = EntityUtil.getResultList(query);

        // IDの最大を戻す。リスト・リポジトリが1つも存在しない場合は0を戻す。
        long id = 0;

        if (list.size() > 0) {
            id = list.get(0).getId();
        }

        return id;
    }

}
