
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ItemStateEnum;

import com.google.appengine.api.datastore.Key;

@Entity
public class ListItemEntity {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Key key;

    @Version
    private long version;

    private long entityVersion;

    @Temporal(TemporalType.TIMESTAMP)
    private Date entityCreateDatetime;

    private EntityStateEnum entityState;

    @ManyToOne
    private ListRepositoryEntity listRepository;

    private String id;

    private String content;

    private ItemStateEnum itemState;

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    public void setEntityVersion(long entityVersion) {
        this.entityVersion = entityVersion;
    }

    public Date getEntityCreateDatetime() {
        return this.entityCreateDatetime;
    }

    public void setEntityCreateDatetime(Date entityCreateDatetime) {
        this.entityCreateDatetime = entityCreateDatetime;
    }

    public EntityStateEnum getEntityState() {
        return this.entityState;
    }

    public void setEntityState(EntityStateEnum entityState) {
        this.entityState = entityState;
    }

    public ListRepositoryEntity getListRepository() {
        return this.listRepository;
    }

    public void setListRepository(ListRepositoryEntity listRepository) {
        this.listRepository = listRepository;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ItemStateEnum getItemState() {
        return this.itemState;
    }

    public void setItemState(ItemStateEnum itemState) {
        this.itemState = itemState;
    }

}
