
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.exception.ListItemNotFoundException;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ItemStateEnum;

public class ListItemDao {

    private EntityManager em;

    public ListItemDao(EntityManager em) {
        this.em = em;
    }

    public ListItemEntity create(ListRepositoryEntity listRepository, String content) {
        // 引数を検証する。
        if (listRepository == null) {
            throw new IllegalArgumentException("listRepository == null");
        }

        if (content == null) {
            throw new IllegalArgumentException("content == null.");
        }

        if (content.trim().length() == 0) {
            throw new IllegalArgumentException("content.length == 0");
        }

        // リスト・アイテムを作成する。
        String id = EntityUtil.getListItemId();

        ListItemEntity entity = new ListItemEntity();
        entity.setEntityVersion(1);
        entity.setEntityCreateDatetime(new Date());
        entity.setEntityState(EntityStateEnum.LATEST);
        entity.setListRepository(listRepository);
        entity.setId(id);
        entity.setContent(content.trim());
        entity.setItemState(ItemStateEnum.INCOMPLETE);

        this.em.persist(entity);

        // 作成したリスト・アイテムを戻す。
        return entity;
    }

    public ListItemEntity update(long entityVersion, String id, String content, ItemStateEnum itemState) {
        // 引数を検証する。
        if (content == null) {
            throw new IllegalArgumentException("content == null");
        }

        if (content.trim().length() == 0) {
            throw new IllegalArgumentException("content.length == 0");
        }

        if (itemState == null) {
            throw new IllegalArgumentException("itemState == null");
        }

        // 最新エンティティを旧エンティティに更新する。
        ListItemEntity oldEntity = this.find(entityVersion, id);
        if (oldEntity == null) {
            throw new ListItemNotFoundException(String.format("entityVersion: %s, id: %s", entityVersion, id));
        }

        oldEntity.setEntityState(EntityStateEnum.OLD);

        this.em.persist(oldEntity);

        // リスト・アイテムを作成する。
        ListItemEntity entity = new ListItemEntity();
        entity.setEntityVersion(oldEntity.getEntityVersion() + 1);
        entity.setEntityCreateDatetime(new Date());
        entity.setEntityState(EntityStateEnum.LATEST);
        entity.setListRepository(oldEntity.getListRepository());
        entity.setId(oldEntity.getId());
        entity.setContent(content);
        entity.setItemState(itemState);

        this.em.persist(entity);

        // 作成したリスト・アイテムを戻す。
        return entity;
    }

    public void delete(long entityVersion, String id) {
        // 最新エンティティを旧エンティティに更新する。
        ListItemEntity oldEntity = this.find(entityVersion, id);
        if (oldEntity == null) {
            throw new ListItemNotFoundException(String.format("entityVersion: %s, id: %s", entityVersion, id));
        }

        oldEntity.setEntityState(EntityStateEnum.OLD);

        this.em.persist(oldEntity);

        // リスト・アイテムを作成する。
        ListItemEntity entity = new ListItemEntity();
        entity.setEntityVersion(oldEntity.getEntityVersion() + 1);
        entity.setEntityCreateDatetime(new Date());
        entity.setEntityState(EntityStateEnum.DELETE);
        entity.setListRepository(oldEntity.getListRepository());
        entity.setId(oldEntity.getId());
        entity.setContent(oldEntity.getContent());
        entity.setItemState(oldEntity.getItemState());

        this.em.persist(entity);
    }

    public ListItemEntity find(long entityVersion, String id) {
        // リスト・アイテムを検索して戻す。
        String queryString = "select e from " + ListItemEntity.class.getName() + " e";
        queryString += " where entityVersion = :entityVersion";
        queryString += " and entityState = :entityState";
        queryString += " and id = :id";

        Query query = this.em.createQuery(queryString);
        query.setParameter("entityVersion", entityVersion);
        query.setParameter("entityState", EntityStateEnum.LATEST);
        query.setParameter("id", id);

        ListItemEntity entity = EntityUtil.getSingleResult(query);

        return entity;
    }

    public List<ListItemEntity> findByListRepository(ListRepositoryEntity listRepositoryEntity) {
        // 引数を検証する。
        if (listRepositoryEntity == null) {
            throw new IllegalArgumentException("listRepositoryEntity == null");
        }

        // リスト・アイテムを検索して戻す。
        String queryString = "select e from " + ListItemEntity.class.getName() + " e";
        queryString += " where entityState = :entityState";
        queryString += " and listRepository = :listRepositoryKey";

        Query query = this.em.createQuery(queryString);
        query.setParameter("entityState", EntityStateEnum.LATEST);
        query.setParameter("listRepositoryKey", listRepositoryEntity.getKey());

        List<ListItemEntity> listItemEntityList = EntityUtil.getResultList(query);

        return listItemEntityList;
    }

}
