
package jp.gr.java_conf.u6k.simple_checklist.gwt.server.entity;

import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;

public final class EntityUtil {

    private static final EntityManagerFactory emf = Persistence.createEntityManagerFactory("transactions-optional");

    private EntityUtil() {
    }

    public static EntityManager createEntityManager() {
        return EntityUtil.emf.createEntityManager();
    }

    @SuppressWarnings("unchecked")
    public static <X> List<X> getResultList(Query query) {
        return query.getResultList();
    }

    @SuppressWarnings("unchecked")
    public static <X> X getSingleResult(Query query) {
        try {
            return (X) query.getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    public static String getListItemId() {
        String id = UUID.randomUUID().toString();

        return id;
    }

}
