
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.widget;

import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.ui.Image;

public class Loading extends LayoutContainer {

    public Loading(String text) {
        this(text, LoadingSizeEnum.SMALL);
    }

    public Loading(String text, LoadingSizeEnum size) {
        Image loadingIcon = null;
        Text messageText = null;

        if (size == LoadingSizeEnum.SMALL) {
            loadingIcon = new Image("resources/image/loading-16x16.gif", 0, 0, 16, 16);

            if (text != null) {
                messageText = new Text(text);
                messageText.setStyleName("x-form-label");
            }
        } else if (size == LoadingSizeEnum.MIDDLE) {
            loadingIcon = new Image("resources/image/loading-24x24.gif", 0, 0, 24, 24);

            if (text != null) {
                messageText = new Text(text);
                messageText.setStyleAttribute("font-size", "18px");
            }
        } else if (size == LoadingSizeEnum.LARGE) {
            loadingIcon = new Image("resources/image/loading-48x48.gif", 0, 0, 48, 48);

            if (text != null) {
                messageText = new Text(text);
                messageText.setStyleAttribute("font-size", "36px");
            }
        } else {
            throw new IllegalArgumentException("size != small | middle | large");
        }

        if (messageText == null) {
            this.add(loadingIcon);
        } else {
            TableLayout layout = new TableLayout(3);
            layout.setCellVerticalAlign(VerticalAlignment.MIDDLE);
            this.setLayout(layout);

            this.add(loadingIcon);

            Text spacer = new Text();
            TableData layoutData = new TableData();
            layoutData.setWidth("3px");
            this.add(spacer, layoutData);

            this.add(messageText);
        }
    }

    public enum LoadingSizeEnum {

        SMALL, MIDDLE, LARGE

    }

}
