
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.widget;

import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.ui.Image;

public class IconText extends LayoutContainer {

    private Image icon;

    private Text spacer;

    private TableData spacerData;

    private Text text;

    public IconText() {
        // 設定
        TableLayout layout = new TableLayout(3);
        this.setLayout(layout);

        // アイコン
        this.icon = new Image();
        this.icon.setPixelSize(16, 16);
        this.add(this.icon);

        // スペーサー
        this.spacer = new Text();

        this.spacerData = new TableData();
        this.spacerData.setWidth("5px");

        this.add(this.spacer, this.spacerData);

        // メッセージ
        this.text = new Text();
        this.add(this.text);
    }

    public void setIconUrl(String url) {
        this.icon.setUrl(url);
    }

    public void setIconPixelSize(int width, int height) {
        this.icon.setPixelSize(width, height);
    }

    public void setSpacerSize(int size) {
        this.spacerData.setWidth(size + "px");
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void setTextStyleName(String styleName) {
        this.text.setStyleName(styleName);
    }

}
