
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListRepositoryStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.widget.Loading;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.widget.Loading.LoadingSizeEnum;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;

public class TopPageView extends AbstractView {

    private LayoutContainer container;

    private Image createListButton;

    private Loading loading;

    public TopPageView(Controller controller) {
        super(controller);

        /*
         * コンポーネントを構築する。
         */

        // コンテナ。
        this.container = new LayoutContainer();

        TableLayout layout = new TableLayout(1);
        layout.setCellSpacing(5);
        layout.setCellHorizontalAlign(HorizontalAlignment.CENTER);
        layout.setCellVerticalAlign(VerticalAlignment.MIDDLE);
        this.container.setLayout(layout);

        // ロゴ・イメージ。
        Image logoImage = new Image("resources/image/simple-checklist-logo.png", 0, 0, 646, 156);

        this.container.add(logoImage);

        // テキスト(ステップ・リスト、大きなメッセージ)。
        LayoutContainer c = new LayoutContainer();
        c.setLayout(new TableLayout(3));

        c.add(this.buildStepList());

        TableData layoutData = new TableData();
        layoutData.setWidth("20px");
        c.add(new Text(), layoutData);

        c.add(this.buildBigMessage());

        this.container.add(c);

        // リスト作成ボタン。
        c = new LayoutContainer();

        this.createListButton = new Image("resources/image/create-list-button.png", 0, 0, 300, 60);
        this.createListButton.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                TopPageView.this.createListButton.setVisible(false);
                TopPageView.this.loading.show();

                Dispatcher.get().dispatch(new CreateListRepositoryStartEvent());
            }

        });

        c.add(this.createListButton);

        // リストを作成していますメッセージ。
        this.loading = new Loading("リストを作成しています...", LoadingSizeEnum.MIDDLE);
        this.loading.hide();

        c.add(this.loading);

        // 利用規約を確認メッセージ。
        layoutData = new TableData();
        layoutData.setHeight("20px");
        c.add(new Text(), layoutData);

        c.add(this.buildTermsOfUseMessage());

        layoutData = new TableData();
        layoutData.setHeight("150px");

        this.container.add(c, layoutData);

        // テキスト(特徴)。
        c = this.buildFeatureList();

        this.container.add(c);
    }

    private LayoutContainer buildStepList() {
        LayoutContainer c = new LayoutContainer();

        String html = "<span class='x-form-label' style='color: #888888'>①リストを作る<br>";
        html += "　　↓<br>";
        html += "②項目を書く<br>";
        html += "　　↓<br>";
        html += "③チェックして消す！</span>";

        c.add(new Html(html));

        return c;
    }

    private LayoutContainer buildBigMessage() {
        LayoutContainer c = new LayoutContainer();

        String html = "<span class='x-form-label' style='color: #888888; font-size: 32px;'>シンプルで簡単な<br>";
        html += "チェックリストツール！</span>";

        c.add(new Html(html));

        return c;
    }

    private LayoutContainer buildTermsOfUseMessage() {
        LayoutContainer c = new LayoutContainer();

        String html = "<span class='x-form-label' style='color: #888888'>ご利用の際は、<a href='terms.html' target='_blank'>利用規約</a>をご確認ください。";
        c.add(new Html(html));

        return c;
    }

    private LayoutContainer buildFeatureList() {
        LayoutContainer c = new LayoutContainer(new TableLayout(1));

        String html = "<span class='x-form-label'><span style='font-weight: bold'>特徴</span>";
        html += "<hr size='1'>";
        html += "<ul>";
        html += "<li>・項目を書いて、消すだけ！　簡単に利用できます。";
        html += "<li>・<span style='color: #cccccc;'>ケータイやiPhoneからもご利用できます。</span>(作成中)";
        html += "<li>・<span style='color: #cccccc;'>項目を階層化したり、優先順位をつけたりできます。</span>(作成中)";
        html += "<li>・<span style='color: #cccccc;'>期限間近にメールを送信など、リマインダーとして利用できます。</span>(作成中)";
        html += "<li>・<span style='color: #cccccc;'>作ったリストを印刷できます。</span>(作成中)";
        html += "</ul>";

        c.add(new Html(html));

        return c;
    }

    @Override
    public Component getComponent() {
        return this.container;
    }

    @Override
    protected void handleEvent(AppEvent event) {
    }

}
