
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ErrorEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.SelectListItemEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ItemStateEnum;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListItemModelData;

import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.i18n.client.DateTimeFormat;

public class ListItemPropertyView extends AbstractView {

    private List<ListItemModelData> selectedList;

    private ContentPanel panel;

    private Text contentText;

    private Text entityCreateDatetimeText;

    private Text itemStateText;

    public ListItemPropertyView(Controller controller) {
        super(controller);

        this.selectedList = new ArrayList<ListItemModelData>();

        // Component構築
        this.panel = new ContentPanel();
        this.panel.setHeading("プロパティ");
        this.panel.setFrame(true);

        TableLayout layout = new TableLayout(2);
        layout.setCellSpacing(5);
        this.panel.setLayout(layout);

        // 項目名ラベル
        this.contentText = new Text();
        this.contentText.setStyleName("x-form-label");

        TableData layoutData = new TableData();
        layoutData.setColspan(2);

        this.panel.add(this.contentText, layoutData);

        // 登録日ラベル
        LabelField label = new LabelField("登録日:");
        label.setWidth(60);
        this.panel.add(label);

        this.entityCreateDatetimeText = new Text();
        this.entityCreateDatetimeText.setStyleName("x-form-label");
        this.panel.add(this.entityCreateDatetimeText);

        // 状態ラベル
        label = new LabelField("状態:");
        label.setWidth(50);
        this.panel.add(label);

        this.itemStateText = new Text();
        this.itemStateText.setStyleName("x-form-label");
        this.panel.add(this.itemStateText);

        this.updateDisplay();
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    protected void handleEvent(AppEvent event) {
        if (event.getType() == SelectListItemEvent.TYPE) {
            SelectListItemEvent ev = (SelectListItemEvent) event;

            List<ListItemModelData> l = ev.getListItemDataList();

            this.selectedList.clear();

            for (ListItemModelData i : l) {
                this.selectedList.add(i.cloneModel());
            }

            this.updateDisplay();

        } else if (event.getType() == UpdateListItemEndEvent.TYPE) {
            UpdateListItemEndEvent ev = (UpdateListItemEndEvent) event;

            List<ListItemModelData> l = ev.getListItemDataList();

            for (ListItemModelData i : l) {
                for (ListItemModelData model : this.selectedList) {
                    if (i.getId().equals(model.getId())) {
                        model.update(i);
                    }
                }
            }

            this.updateDisplay();

        }
    }

    private void updateDisplay() {
        if (this.selectedList.size() == 0) {
            this.contentText.hide();
            this.entityCreateDatetimeText.setText("<未選択>");
            this.itemStateText.setText("<未選択>");

        } else if (this.selectedList.size() == 1) {
            ListItemModelData listItem = this.selectedList.get(0);

            this.contentText.show();
            this.contentText.setText(listItem.getContent());

            if (listItem.getEntityCreateDatetime() != null) {
                DateTimeFormat formatter = DateTimeFormat.getFormat("yyyy/MM/dd HH:mm:ss");
                this.entityCreateDatetimeText.setText(formatter.format(listItem.getEntityCreateDatetime()));
            }

            if (listItem.getItemState() != null) {
                if (listItem.getItemState() == ItemStateEnum.COMPLETED) {
                    this.itemStateText.setText("完了");
                } else if (listItem.getItemState() == ItemStateEnum.INCOMPLETE) {
                    this.itemStateText.setText("未完了");
                } else {
                    Dispatcher.get().dispatch(new ErrorEvent(new RuntimeException()));
                }
            }

        } else {
            this.contentText.hide();
            this.entityCreateDatetimeText.setText("<複数選択>");
            this.itemStateText.setText("<複数選択>");

        }
    }
}
