
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.DeleteListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ErrorEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.SelectListItemEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ItemStateEnum;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListItemModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.util.ClientStringUtil;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.util.RegistryUtil;

import com.extjs.gxt.ui.client.Style.SortDir;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.store.Record.RecordUpdate;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid.ClicksToEdit;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Image;

public class ListItemListView extends AbstractView {

    private ContentPanel panel;

    private EditorGrid<ListItemModelData> grid;

    private ListStore<ListItemModelData> gridStore;

    public ListItemListView(Controller controller) {
        super(controller);

        // Component構築
        this.panel = new ContentPanel();
        this.panel.setHeading("リスト");
        this.panel.setLayout(new FitLayout());

        // ヘッダー
        LayoutContainer headerContainer = new LayoutContainer();
        headerContainer.setBorders(true);

        TableLayout layout = new TableLayout();
        layout.setCellSpacing(5);
        headerContainer.setLayout(layout);

        headerContainer.add(this.buildSelectMenu());

        this.panel.setTopComponent(headerContainer);

        // グリッド
        this.buildGrid();

        this.panel.add(this.grid);
    }

    private LayoutContainer buildSelectMenu() {
        LayoutContainer c = new LayoutContainer();

        TableLayout layout = new TableLayout(8);
        c.setLayout(layout);

        // 選択
        Text text = new Text("選択: ");
        text.setStyleName("x-form-label");

        c.add(text);

        // すべて選択
        Anchor selectAnchor = new Anchor("すべて選択");
        selectAnchor.setStyleName("x-form-label");
        selectAnchor.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                List<ListItemModelData> modelList = ListItemListView.this.gridStore.getModels();

                ListItemListView.this.grid.getSelectionModel().selectAll();

                Dispatcher.get().dispatch(new SelectListItemEvent(modelList));
            }

        });

        c.add(selectAnchor);

        // 区切り
        text = new Text("|");

        TableData layoutData = new TableData();
        layoutData.setWidth("10px");

        c.add(text, layoutData);

        // 選択解除
        selectAnchor = new Anchor("選択解除");
        selectAnchor.setStyleName("x-form-label");
        selectAnchor.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                List<ListItemModelData> modelList = new ArrayList<ListItemModelData>();

                ListItemListView.this.grid.getSelectionModel().deselectAll();

                Dispatcher.get().dispatch(new SelectListItemEvent(modelList));
            }

        });

        c.add(selectAnchor);

        // 区切り
        text = new Text("|");

        layoutData = new TableData();
        layoutData.setWidth("10px");

        c.add(text, layoutData);

        // 未完了を選択
        selectAnchor = new Anchor("未完了を選択");
        selectAnchor.setStyleName("x-form-label");
        selectAnchor.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                List<ListItemModelData> modelList = ListItemListView.this.gridStore.getModels();

                List<ListItemModelData> selectList = new ArrayList<ListItemModelData>();
                for (ListItemModelData model : modelList) {
                    if (model.getItemState() == ItemStateEnum.INCOMPLETE) {
                        selectList.add(model);
                    }
                }

                ListItemListView.this.grid.getSelectionModel().select(selectList, false);

                Dispatcher.get().dispatch(new SelectListItemEvent(selectList));
            }

        });

        c.add(selectAnchor);

        // 区切り
        text = new Text("|");

        layoutData = new TableData();
        layoutData.setWidth("10px");

        c.add(text, layoutData);

        // 完了を選択
        selectAnchor = new Anchor("完了を選択");
        selectAnchor.setStyleName("x-form-label");
        selectAnchor.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                List<ListItemModelData> modelList = ListItemListView.this.gridStore.getModels();

                List<ListItemModelData> selectList = new ArrayList<ListItemModelData>();
                for (ListItemModelData model : modelList) {
                    if (model.getItemState() == ItemStateEnum.COMPLETED) {
                        selectList.add(model);
                    }
                }

                ListItemListView.this.grid.getSelectionModel().select(selectList, false);

                Dispatcher.get().dispatch(new SelectListItemEvent(selectList));
            }

        });

        c.add(selectAnchor);

        return c;
    }

    private void buildGrid() {
        /*
         * カラム設定。
         */
        List<ColumnConfig> columnConfigList = new ArrayList<ColumnConfig>();

        // 1列目・チェック
        ColumnConfig columnConfig = new ColumnConfig("itemState", "状態", 35);
        columnConfig.setRenderer(new GridCellRenderer<ListItemModelData>() {

            @Override
            public Object render(ListItemModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ListItemModelData> store, Grid<ListItemModelData> grid) {
                switch (model.getItemState()) {
                    case COMPLETED:
                        return new Image("resources/icon/tick.png", 0, 0, 16, 16);

                    case INCOMPLETE:
                        return new Image("resources/icon/time.png", 0, 0, 16, 16);

                    default:
                        Dispatcher.get().dispatch(new ErrorEvent(new RuntimeException("認識できないitemState: " + model.getItemState())));
                        return null;
                }
            }

        });

        columnConfigList.add(columnConfig);

        // 2列目・内容
        columnConfig = new ColumnConfig("content", "内容", 1000);

        TextField<String> contentField = new TextField<String>();
        contentField.setSelectOnFocus(true);
        columnConfig.setEditor(new CellEditor(contentField));

        columnConfig.setRenderer(new GridCellRenderer<ListItemModelData>() {

            @Override
            public Object render(ListItemModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ListItemModelData> store, Grid<ListItemModelData> grid) {
                String content = ClientStringUtil.htmlEscape(model.getContent());

                return content;
            }

        });

        columnConfigList.add(columnConfig);

        /*
         * グリッド・ストア。
         */
        this.gridStore = new GroupingStore<ListItemModelData>();
        this.gridStore.sort("entityCreateDatetime", SortDir.ASC);

        List<ListItemModelData> listItemList = RegistryUtil.getListItemList();

        for (ListItemModelData listItem : listItemList) {
            this.gridStore.add(listItem.cloneModel());
        }

        this.gridStore.addStoreListener(new StoreListener<ListItemModelData>() {

            @Override
            public void storeUpdate(StoreEvent<ListItemModelData> se) {
                if (se.getOperation() == RecordUpdate.EDIT) {
                    List<ListItemModelData> listItemList = new ArrayList<ListItemModelData>();
                    listItemList.add(se.getModel());

                    Dispatcher.get().dispatch(new UpdateListItemStartEvent(listItemList));
                }
            }

        });

        this.grid = new EditorGrid<ListItemModelData>(this.gridStore, new ColumnModel(columnConfigList));
        this.grid.setClicksToEdit(ClicksToEdit.TWO);
        this.grid.setSelectionModel(new GridSelectionModel<ListItemModelData>());

        this.grid.addListener(Events.ValidateEdit, new Listener<GridEvent<ListItemModelData>>() {

            @Override
            public void handleEvent(GridEvent<ListItemModelData> be) {
                if (be.getValue() == null) {
                    be.setCancelled(true);
                }
            }

        });

        this.grid.getSelectionModel().addSelectionChangedListener(new SelectionChangedListener<ListItemModelData>() {

            @Override
            public void selectionChanged(SelectionChangedEvent<ListItemModelData> se) {
                Dispatcher.get().dispatch(new SelectListItemEvent(ListItemListView.this.grid.getSelectionModel().getSelectedItems()));
            }

        });
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    protected void handleEvent(AppEvent event) {
        if (event.getType() == CreateListItemEndEvent.TYPE) {
            CreateListItemEndEvent ev = (CreateListItemEndEvent) event;

            ListItemModelData listItem = ev.getListItemData();

            this.gridStore.add(listItem.cloneModel());

            this.gridStore.sort(this.gridStore.getSortField(), this.gridStore.getSortDir());
            this.gridStore.commitChanges();

        } else if (event.getType() == UpdateListItemEndEvent.TYPE) {
            UpdateListItemEndEvent ev = (UpdateListItemEndEvent) event;

            List<ListItemModelData> listItemList = ev.getListItemDataList();

            for (ListItemModelData listItem : listItemList) {
                ListItemModelData model = this.gridStore.findModel("id", listItem.getId());
                model.update(listItem);

                this.gridStore.update(model);
            }

            this.gridStore.sort(this.gridStore.getSortField(), this.gridStore.getSortDir());
            this.gridStore.commitChanges();

        } else if (event.getType() == DeleteListItemEndEvent.TYPE) {
            List<ListItemModelData> removeList = new ArrayList<ListItemModelData>();

            DeleteListItemEndEvent ev = (DeleteListItemEndEvent) event;

            List<ListItemModelData> listItemList = ev.getListItemDataList();

            for (ListItemModelData listItem : listItemList) {
                ListItemModelData model = this.gridStore.findModel("id", listItem.getId());
                removeList.add(model);
            }

            for (ListItemModelData model : removeList) {
                this.gridStore.remove(model);
            }

            this.gridStore.sort(this.gridStore.getSortField(), this.gridStore.getSortDir());
            this.gridStore.commitChanges();

        }
    }

}
