
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.DeleteListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.SelectListItemEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ItemStateEnum;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListItemModelData;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;

public class ListItemActionView extends AbstractView {

    private List<ListItemModelData> selectedList;

    private ContentPanel panel;

    public ListItemActionView(Controller controller) {
        super(controller);

        this.selectedList = new ArrayList<ListItemModelData>();

        // Component構築
        this.panel = new ContentPanel();
        this.panel.setHeading("アクション");
        this.panel.setFrame(true);

        TableLayout layout = new TableLayout(1);
        layout.setCellSpacing(5);
        this.panel.setLayout(layout);

        // 登録ボタン
        Button createItemButton = new Button("リストに登録");
        createItemButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

            @Override
            public void componentSelected(ButtonEvent ce) {
                MessageBox.prompt("リストに登録", "リストに登録します。入力してください。", new Listener<MessageBoxEvent>() {

                    @Override
                    public void handleEvent(MessageBoxEvent be) {
                        if (be.getButtonClicked().getText().equals(GXT.MESSAGES.messageBox_ok()) && be.getValue() != null) {
                            ListItemModelData listItem = new ListItemModelData();
                            listItem.setContent(be.getValue());
                            listItem.setItemState(ItemStateEnum.INCOMPLETE);

                            Dispatcher.get().dispatch(new CreateListItemStartEvent(listItem));
                        }
                    }

                });
            }

        });
        this.panel.add(createItemButton);

        // 完了ボタン
        Button completeItemButton = new Button("完了にする");
        completeItemButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

            @Override
            public void componentSelected(ButtonEvent ce) {
                if (ListItemActionView.this.selectedList.size() > 0) {
                    for (ListItemModelData listItem : ListItemActionView.this.selectedList) {
                        listItem.setItemState(ItemStateEnum.COMPLETED);
                    }

                    Dispatcher.get().dispatch(new UpdateListItemStartEvent(ListItemActionView.this.selectedList));
                }
            }
        });
        this.panel.add(completeItemButton);

        // 削除ボタン
        Button deleteItemButton = new Button("リストから削除");
        deleteItemButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

            @Override
            public void componentSelected(ButtonEvent ce) {
                if (ListItemActionView.this.selectedList.size() > 0) {
                    Dispatcher.get().dispatch(new DeleteListItemStartEvent(ListItemActionView.this.selectedList));
                }
            }

        });
        this.panel.add(deleteItemButton);
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    protected void handleEvent(AppEvent event) {
        if (event.getType() == SelectListItemEvent.TYPE) {
            SelectListItemEvent ev = (SelectListItemEvent) event;

            List<ListItemModelData> l = ev.getListItemDataList();

            this.selectedList.clear();

            for (ListItemModelData i : l) {
                this.selectedList.add(i.cloneModel());
            }

        } else if (event.getType() == UpdateListItemEndEvent.TYPE) {
            UpdateListItemEndEvent ev = (UpdateListItemEndEvent) event;

            List<ListItemModelData> l = ev.getListItemDataList();

            for (ListItemModelData i : l) {
                for (ListItemModelData model : this.selectedList) {
                    if (i.getId().equals(model.getId())) {
                        model.update(i);
                    }
                }
            }

        }
    }

}
