
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListRepositoryEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListRepositoryStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListRepositoryModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.util.RegistryUtil;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;

public class HeaderView extends AbstractView {

    private LayoutContainer container;

    private Text listNameText;

    private TextField<String> listNameField;

    private Image listNameEditIcon;

    public HeaderView(Controller controller) {
        super(controller);

        // Component構築
        this.container = new LayoutContainer();

        TableLayout layout = new TableLayout(2);
        layout.setWidth("100%");

        this.container.setLayout(layout);

        // ロゴ
        LayoutContainer c = new LayoutContainer();

        layout = new TableLayout(5);
        layout.setCellVerticalAlign(VerticalAlignment.MIDDLE);
        c.setLayout(layout);

        Image logoImage = new Image("resources/image/simple-checklist-logo-small.png", 0, 0, 190, 23);
        c.add(logoImage);

        // リストの名前
        TableData layoutData = new TableData();
        layoutData.setWidth("30px");
        c.add(new Text(), layoutData);

        ListRepositoryModelData listRepositoryData = RegistryUtil.getListRepository();

        this.listNameText = new Text(listRepositoryData.getName());
        c.add(this.listNameText);

        this.listNameField = new TextField<String>();
        this.listNameField.setWidth(200);
        this.listNameField.setSelectOnFocus(true);
        this.listNameField.addKeyListener(new KeyListener() {

            @Override
            public void componentKeyPress(ComponentEvent event) {
                if (event.getKeyCode() == 13) {
                    HeaderView.this.listNameText.show();
                    HeaderView.this.listNameField.hide();
                    HeaderView.this.listNameEditIcon.setVisible(true);

                    String newListName = HeaderView.this.listNameField.getValue();
                    if (newListName == null) {
                        return;
                    }

                    newListName = newListName.trim();

                    if (newListName.length() == 0) {
                        return;
                    }

                    ListRepositoryModelData listRepositoryData = RegistryUtil.getListRepository();
                    listRepositoryData.setName(newListName);
                    Dispatcher.get().dispatch(new UpdateListRepositoryStartEvent(listRepositoryData));
                } else if (event.getKeyCode() == 27) {
                    HeaderView.this.listNameText.show();
                    HeaderView.this.listNameField.hide();
                    HeaderView.this.listNameEditIcon.setVisible(true);
                }
            }

        });
        this.listNameField.hide();
        c.add(this.listNameField);

        this.listNameEditIcon = new Image("resources/icon/pencil.png", 0, 0, 16, 16);
        this.listNameEditIcon.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                ListRepositoryModelData d = RegistryUtil.getListRepository();
                HeaderView.this.listNameField.setValue(d.getName());

                HeaderView.this.listNameText.hide();
                HeaderView.this.listNameField.show();
                HeaderView.this.listNameEditIcon.setVisible(false);

                HeaderView.this.listNameField.focus();
            }

        });
        c.add(this.listNameEditIcon);

        layoutData = new TableData();
        layoutData.setHorizontalAlign(HorizontalAlignment.LEFT);
        layoutData.setVerticalAlign(VerticalAlignment.MIDDLE);

        this.container.add(c, layoutData);

        // 設定・ボタン
        c = new LayoutContainer();

        layout = new TableLayout(2);
        layout.setCellSpacing(5);
        layout.setCellVerticalAlign(VerticalAlignment.MIDDLE);
        c.setLayout(layout);

        Button configButton = new Button("設定");
        c.add(configButton);

        // ヘルプ・ボタン
        Button helpButton = new Button("ヘルプ");
        c.add(helpButton);

        layoutData = new TableData();
        layoutData.setHorizontalAlign(HorizontalAlignment.RIGHT);
        layoutData.setVerticalAlign(VerticalAlignment.MIDDLE);

        this.container.add(c, layoutData);
    }

    @Override
    public Component getComponent() {
        return this.container;
    }

    @Override
    protected void handleEvent(AppEvent event) {
        if (event.getType() == UpdateListRepositoryEndEvent.TYPE) {
            UpdateListRepositoryEndEvent ev = (UpdateListRepositoryEndEvent) event;
            ListRepositoryModelData updatedListRepository = ev.getListRepository();

            this.listNameText.setText(updatedListRepository.getName());
        }
    }

}
