
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.util.ClientStringUtil;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;

public class FooterView extends AbstractView {

    private LayoutContainer container;

    public FooterView(Controller controller) {
        super(controller);

        // Component構築
        this.container = new LayoutContainer();

        TableLayout layout = new TableLayout(1);
        layout.setWidth("100%");
        layout.setCellHorizontalAlign(HorizontalAlignment.CENTER);
        layout.setCellSpacing(5);

        this.container.setLayout(layout);

        String url = ClientStringUtil.getTopUrl();
        String mail = "simple.checklist@gmail.com";

        String html = "<span class='x-form-label'>";
        html += "Copyright (C) 2009 simple.checklist@gmail.com All Rights Reserved.";
        html += "&nbsp;&nbsp;|&nbsp;&nbsp;";
        html += "<a href='" + url + "'>トップ</a>";
        html += "&nbsp;&nbsp;|&nbsp;&nbsp;";
        html += "<a href='terms.html' target='_blank'>利用規約</a>";
        html += "&nbsp;&nbsp;|&nbsp;&nbsp;";
        html += "<a href='help.html' target='_blank'>ヘルプ</a>";
        html += "&nbsp;&nbsp;|&nbsp;&nbsp;";
        html += "<a href='mailto:" + mail + "'>お問い合わせ</a>";
        html += "</span>";

        this.container.add(new Html(html));
    }

    @Override
    public Component getComponent() {
        return this.container;
    }

    @Override
    protected void handleEvent(AppEvent event) {
    }

}
