
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.view;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CloseAnnounceEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ShowAnnounceEvent;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;

public class AnnounceView extends AbstractView {

    private ContentPanel panel;

    private LabelField messageLabel;

    public AnnounceView(Controller controller) {
        super(controller);

        // Component構築
        this.panel = new ContentPanel();
        this.panel.setHeading("お知らせ");
        this.panel.setFrame(true);

        TableLayout layout = new TableLayout(1);
        layout.setWidth("100%");
        layout.setHeight("100%");
        layout.setCellSpacing(5);

        this.panel.setLayout(layout);

        // ラベル
        this.messageLabel = new LabelField();

        TableData layoutData = new TableData();
        layoutData.setHorizontalAlign(HorizontalAlignment.LEFT);
        layoutData.setVerticalAlign(VerticalAlignment.TOP);

        this.panel.add(this.messageLabel, layoutData);

        // 閉じるボタン
        Button hideButton = new Button("お知らせを閉じる");
        hideButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

            @Override
            public void componentSelected(ButtonEvent ce) {
                Dispatcher.get().dispatch(CloseAnnounceEvent.TYPE);
            }

        });

        layoutData = new TableData();
        layoutData.setHorizontalAlign(HorizontalAlignment.RIGHT);
        layoutData.setVerticalAlign(VerticalAlignment.BOTTOM);

        this.panel.add(hideButton, layoutData);
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    protected void handleEvent(AppEvent event) {
        if (event.getType() == ShowAnnounceEvent.TYPE) {
            ShowAnnounceEvent ev = (ShowAnnounceEvent) event;

            String message = ev.getMessage();

            this.messageLabel.setValue(message);
        }
    }

}
