
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.util;

import java.util.List;

import com.google.gwt.user.client.Window.Location;

public final class ClientStringUtil {

    private ClientStringUtil() {
    }

    public static String getTopUrl() {
        String url = Location.getProtocol() + "//" + Location.getHost() + Location.getPath();

        String queryString = "";
        for (String paramName : Location.getParameterMap().keySet()) {
            if (!"id".equals(paramName)) {
                List<String> paramValueList = Location.getParameterMap().get(paramName);

                for (String paramValue : paramValueList) {
                    if (queryString.length() > 0) {
                        queryString += "&";
                    }

                    queryString += paramName + "=" + paramValue;
                }
            }
        }

        if (queryString.length() > 0) {
            url += "?" + queryString;
        }

        return url;
    }

    public static String htmlEscape(String text) {
        if (text == null) {
            return null;
        }

        String html = text;
        html = html.replaceAll("&", "&amp;");
        html = html.replaceAll("<", "&lt;");
        html = html.replaceAll(">", "&gt;");
        html = html.replaceAll("\"", "&quot;");
        html = html.replaceAll("'", "&#39;");

        return html;
    }

}
