
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata;

import java.util.Date;

import com.extjs.gxt.ui.client.data.BaseModelData;

@SuppressWarnings("serial")
public class ListItemModelData extends BaseModelData {

    public ListItemModelData cloneModel() {
        ListItemModelData clone = new ListItemModelData();
        clone.setProperties(this.getProperties());

        return clone;
    }

    public void update(ListItemModelData src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }

        this.setProperties(src.getProperties());
    }

    public long getEntityVersion() {
        return this.get("entityVersion");
    }

    public void setEntityVersion(long entityVersion) {
        this.set("entityVersion", entityVersion);
    }

    public Date getEntityCreateDatetime() {
        return this.get("entityCreateDatetime");
    }

    public void setEntityCreateDatetime(Date entityCreateDatetime) {
        this.set("entityCreateDatetime", entityCreateDatetime);
    }

    public String getId() {
        return this.get("id");
    }

    public void setId(String id) {
        this.set("id", id);
    }

    public String getContent() {
        return this.get("content");
    }

    public void setContent(String content) {
        this.set("content", content);
    }

    public ItemStateEnum getItemState() {
        Integer itemStateValue = this.get("itemState");

        if (itemStateValue != null) {
            return ItemStateEnum.valueOf(itemStateValue);
        } else {
            return null;
        }
    }

    public void setItemState(ItemStateEnum itemState) {
        if (itemState != null) {
            this.set("itemState", itemState.getValue());
        } else {
            this.set("itemState", null);
        }
    }

    @Override
    public String toString() {
        String s = "";

        for (String name : this.getPropertyNames()) {
            if (s.length() > 0) {
                s += ", ";
            }

            s += name + ": " + this.get(name);
        }

        s = "ListItemModelData[" + s + "]";

        return s;
    }

}
