
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.controller;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListRepositoryEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListRepositoryStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ErrorEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.InitEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListRepositoryModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.service.ListRepositoryService;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.service.ListRepositoryServiceAsync;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.util.ClientStringUtil;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.AbstractView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.FooterView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.TopPageView;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.mvc.View;
import com.extjs.gxt.ui.client.widget.Viewport;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window.Location;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;

public class TopViewController extends AbstractController {

    private ListRepositoryServiceAsync listRepositoryService = GWT.create(ListRepositoryService.class);

    private List<AbstractView> viewList;

    private Viewport viewport;

    public TopViewController() {
        super();

        this.viewList = new ArrayList<AbstractView>();

        this.registerEventTypes(InitEvent.TYPE);
        this.registerEventTypes(CreateListRepositoryStartEvent.TYPE);
        this.registerEventTypes(CreateListRepositoryEndEvent.TYPE);
    }

    @Override
    public void handleEvent(AppEvent event) {
        if (event.getType() == InitEvent.TYPE) {
            this.viewport = new Viewport();
            this.viewport.setScrollMode(Scroll.AUTO);

            TableLayout layout = new TableLayout(1);
            layout.setCellHorizontalAlign(HorizontalAlignment.CENTER);
            layout.setWidth("100%");

            this.viewport.setLayout(layout);

            // リスト作成パネル
            TopPageView topPageView = new TopPageView(this);
            this.viewList.add(topPageView);

            this.viewport.add(topPageView.getComponent());

            // フッター
            FooterView footerView = new FooterView(this);
            this.viewList.add(footerView);

            TableData layoutData = new TableData();
            layoutData.setHeight("50px");
            layoutData.setVerticalAlign(VerticalAlignment.BOTTOM);

            this.viewport.add(footerView.getComponent(), layoutData);

            RootPanel.get().add(this.viewport);

        } else if (event.getType() == CreateListRepositoryStartEvent.TYPE) {
            this.createListRepository();

        } else if (event.getType() == CreateListRepositoryEndEvent.TYPE) {
            CreateListRepositoryEndEvent ev = (CreateListRepositoryEndEvent) event;
            ListRepositoryModelData listRepositoryData = ev.getListRepositoryData();

            String url = ClientStringUtil.getTopUrl();
            if (Location.getQueryString() != null && Location.getQueryString().length() > 0) {
                url += "&id=" + listRepositoryData.getId();
            } else {
                url += "?id=" + listRepositoryData.getId();
            }

            Location.replace(url);

        } else {
            super.handleEvent(event);

        }

        for (View view : this.viewList) {
            this.forwardToView(view, event);
        }
    }

    private void createListRepository() {
        this.listRepositoryService.createListRepository(new AsyncCallback<ListRepositoryModelData>() {

            @Override
            public void onSuccess(ListRepositoryModelData listRepositoryData) {
                CreateListRepositoryEndEvent ev = new CreateListRepositoryEndEvent(listRepositoryData);
                Dispatcher.get().dispatch(ev);
            }

            @Override
            public void onFailure(Throwable caught) {
                ErrorEvent ev = new ErrorEvent(caught);
                Dispatcher.get().dispatch(ev);
            }

        });
    }

}
