
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CloseAnnounceEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.CreateListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.DeleteListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.DeleteListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ErrorEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.InitEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.SelectListItemEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ShowAnnounceEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListItemStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListRepositoryEndEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.UpdateListRepositoryStartEvent;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListItemModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.modeldata.ListRepositoryModelData;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.service.ListRepositoryService;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.service.ListRepositoryServiceAsync;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.util.RegistryUtil;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.AbstractView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.AnnounceView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.FooterView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.HeaderView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.ListItemActionView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.ListItemListView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.view.ListItemPropertyView;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.widget.Loading;
import jp.gr.java_conf.u6k.simple_checklist.gwt.client.widget.Loading.LoadingSizeEnum;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.mvc.View;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Viewport;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;

public class ListViewController extends AbstractController {

    private ListRepositoryServiceAsync listRepositoryService = GWT.create(ListRepositoryService.class);

    private List<AbstractView> viewList;

    private LayoutContainer layoutContainer2;

    private Viewport viewport;

    public ListViewController() {
        this.viewList = new ArrayList<AbstractView>();

        this.registerEventTypes(InitEvent.TYPE);
        this.registerEventTypes(UpdateListRepositoryStartEvent.TYPE);
        this.registerEventTypes(UpdateListRepositoryEndEvent.TYPE);
        this.registerEventTypes(CreateListItemStartEvent.TYPE);
        this.registerEventTypes(CreateListItemEndEvent.TYPE);
        this.registerEventTypes(UpdateListItemStartEvent.TYPE);
        this.registerEventTypes(UpdateListItemEndEvent.TYPE);
        this.registerEventTypes(DeleteListItemStartEvent.TYPE);
        this.registerEventTypes(DeleteListItemEndEvent.TYPE);
        this.registerEventTypes(SelectListItemEvent.TYPE);
        this.registerEventTypes(ShowAnnounceEvent.TYPE);
        this.registerEventTypes(CloseAnnounceEvent.TYPE);
    }

    @Override
    public void handleEvent(AppEvent event) {
        if (event.getType() == InitEvent.TYPE) {
            GWT.log("event: init", null);

            // 初期化。
            this.viewport = new Viewport();
            this.viewport.setLayout(new CenterLayout());

            Loading loading = new Loading("データ読み込み中...", LoadingSizeEnum.MIDDLE);
            this.viewport.add(loading);

            RootPanel.get().add(this.viewport);

            // 初期化開始
            this.initFindListRepository();

        } else if (event.getType() == UpdateListRepositoryStartEvent.TYPE) {
            GWT.log("event: updateListRepositoryStart", null);

            // リスト・リポジトリ更新開始。
            UpdateListRepositoryStartEvent ev = (UpdateListRepositoryStartEvent) event;

            ListRepositoryModelData listRepositoryData = ev.getListRepository();

            this.updateListRepository(listRepositoryData);

        } else if (event.getType() == UpdateListRepositoryEndEvent.TYPE) {
            GWT.log("event: updateListRepositoryEnd", null);

            // リスト・リポジトリ更新終了。

        } else if (event.getType() == CreateListItemStartEvent.TYPE) {
            GWT.log("event: createListItemStart", null);

            // リスト・アイテム作成開始。
            CreateListItemStartEvent ev = (CreateListItemStartEvent) event;

            ListItemModelData listItem = ev.getListItemData();

            this.createListItem(listItem);

        } else if (event.getType() == CreateListItemEndEvent.TYPE) {
            GWT.log("event: createListItemEnd", null);

            // リスト・アイテム作成終了。

        } else if (event.getType() == UpdateListItemStartEvent.TYPE) {
            GWT.log("event: updateListItemStart", null);

            // リスト・アイテム更新開始。
            UpdateListItemStartEvent ev = (UpdateListItemStartEvent) event;

            List<ListItemModelData> listItemList = ev.getListItemDataList();

            this.updateListItem(listItemList);

        } else if (event.getType() == UpdateListItemEndEvent.TYPE) {
            GWT.log("event: updateListItemEnd", null);

            // リスト・アイテム更新終了。

        } else if (event.getType() == DeleteListItemStartEvent.TYPE) {
            GWT.log("event: deleteListItemStart", null);

            // リスト・アイテム削除開始。
            DeleteListItemStartEvent ev = (DeleteListItemStartEvent) event;

            List<ListItemModelData> listItemList = ev.getListItemDataList();

            this.deleteListItem(listItemList);

        } else if (event.getType() == DeleteListItemEndEvent.TYPE) {
            GWT.log("event: deleteListItemEnd", null);

            // リスト・アイテム削除終了。

        } else if (event.getType() == SelectListItemEvent.TYPE) {
            GWT.log("event: selectListItem", null);

            // リスト・アイテム選択。

        } else if (event.getType() == ShowAnnounceEvent.TYPE) {
            GWT.log("event: showAnnounce", null);

            // お知らせ表示。
            BorderLayout layout = (BorderLayout) this.layoutContainer2.getLayout();
            layout.show(LayoutRegion.NORTH);

        } else if (event.getType() == CloseAnnounceEvent.TYPE) {
            GWT.log("event: closeAnnounce", null);

            // お知らせ閉じる。
            BorderLayout layout = (BorderLayout) ListViewController.this.layoutContainer2.getLayout();
            layout.hide(LayoutRegion.NORTH);

        } else {
            // その他。
            super.handleEvent(event);

        }

        for (View view : this.viewList) {
            this.forwardToView(view, event);
        }
    }

    private void initFindListRepository() {
        long listRepositoryId = RegistryUtil.getListRepositoryId();

        this.listRepositoryService.findListRepositoryByListRepositoryId(listRepositoryId, new AsyncCallback<ListRepositoryModelData>() {

            @Override
            public void onSuccess(ListRepositoryModelData listRepositoryData) {
                RegistryUtil.setListRepository(listRepositoryData);

                ListViewController.this.initFindListItem();
            }

            @Override
            public void onFailure(Throwable caught) {
                Dispatcher.get().dispatch(new ErrorEvent(caught));
            }

        });
    }

    private void initFindListItem() {
        long listRepositoryId = RegistryUtil.getListRepositoryId();

        this.listRepositoryService.findListItemByListRepositoryId(listRepositoryId, new AsyncCallback<List<ListItemModelData>>() {

            @Override
            public void onSuccess(List<ListItemModelData> listItemDataList) {
                RegistryUtil.setListItemList(listItemDataList);

                ListViewController.this.initBuildWidget();
            }

            @Override
            public void onFailure(Throwable caught) {
                Dispatcher.get().dispatch(new ErrorEvent(caught));
            }

        });
    }

    private void initBuildWidget() {
        this.viewport.removeAll();

        this.viewport.setLayout(new FitLayout());

        // レイアウト・コンテナ1
        LayoutContainer layoutContainer1 = new LayoutContainer();
        layoutContainer1.setStyleAttribute("background-color", "white");

        BorderLayout layout1 = new BorderLayout();
        layoutContainer1.setLayout(layout1);

        // ヘッダー
        HeaderView headerView = new HeaderView(this);
        this.viewList.add(headerView);

        BorderLayoutData layoutData = new BorderLayoutData(LayoutRegion.NORTH);
        layoutData.setMargins(new Margins(5, 5, 0, 5));
        layoutData.setSize(30);

        layoutContainer1.add(headerView.getComponent(), layoutData);

        // レイアウト・コンテナ2
        this.layoutContainer2 = new LayoutContainer();
        this.layoutContainer2.setStyleAttribute("background-color", "white");

        BorderLayout layout2 = new BorderLayout();
        this.layoutContainer2.setLayout(layout2);

        // お知らせパネル
        AnnounceView announceView = new AnnounceView(this);
        this.viewList.add(announceView);

        layoutData = new BorderLayoutData(LayoutRegion.NORTH);
        layoutData.setMargins(new Margins(5, 5, 0, 5));
        layoutData.setSize(100);

        this.layoutContainer2.add(announceView.getComponent(), layoutData);

        // リスト・ビュー
        ListItemListView listItemListView = new ListItemListView(this);
        this.viewList.add(listItemListView);

        layoutData = new BorderLayoutData(LayoutRegion.CENTER);
        layoutData.setMargins(new Margins(5));

        this.layoutContainer2.add(listItemListView.getComponent(), layoutData);

        // メニュー・コンテナ
        LayoutContainer menuContainer = new LayoutContainer();

        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setWidth("100%");

        menuContainer.setLayout(tableLayout);

        // リスト・アイテム・アクション・パネル
        ListItemActionView listItemActionView = new ListItemActionView(this);
        this.viewList.add(listItemActionView);

        menuContainer.add(listItemActionView.getComponent());

        // リスト・アイテム・プロパティ・パネル
        ListItemPropertyView listItemPropertyView = new ListItemPropertyView(this);
        this.viewList.add(listItemPropertyView);

        TableData tableLayoutData = new TableData();
        tableLayoutData.setStyle("padding-top: 5px");

        menuContainer.add(listItemPropertyView.getComponent(), tableLayoutData);

        layoutData = new BorderLayoutData(LayoutRegion.EAST);
        layoutData.setCollapsible(true);
        layoutData.setMinSize(100);
        layoutData.setSize(250);
        layoutData.setSplit(true);
        layoutData.setMargins(new Margins(5, 5, 5, 0));

        this.layoutContainer2.add(menuContainer, layoutData);

        layoutData = new BorderLayoutData(LayoutRegion.CENTER);

        layoutContainer1.add(this.layoutContainer2, layoutData);

        // フッター
        FooterView footerView = new FooterView(this);
        this.viewList.add(footerView);

        layoutData = new BorderLayoutData(LayoutRegion.SOUTH);
        layoutData.setSize(30);

        layoutContainer1.add(footerView.getComponent(), layoutData);

        this.viewport.add(layoutContainer1);

        this.viewport.layout();

        // お知らせパネルを隠す
        layout2.hide(LayoutRegion.NORTH);
    }

    private void updateListRepository(ListRepositoryModelData listRepositoryData) {
        this.listRepositoryService.updateListRepository(listRepositoryData, new AsyncCallback<ListRepositoryModelData>() {

            @Override
            public void onSuccess(ListRepositoryModelData updatedListRepositoryData) {
                ListRepositoryModelData listRepositoryData = RegistryUtil.getListRepository();
                listRepositoryData.update(updatedListRepositoryData);

                Dispatcher.get().dispatch(new UpdateListRepositoryEndEvent(listRepositoryData));
            }

            @Override
            public void onFailure(Throwable caught) {
                Dispatcher.get().dispatch(new ErrorEvent(caught));
            }

        });
    }

    private void createListItem(ListItemModelData listItemData) {
        long listRepositoryId = RegistryUtil.getListRepositoryId();

        this.listRepositoryService.createListItem(listRepositoryId, listItemData, new AsyncCallback<ListItemModelData>() {

            @Override
            public void onSuccess(ListItemModelData listItemData) {
                List<ListItemModelData> listItemDataList = RegistryUtil.getListItemList();
                listItemDataList.add(listItemData);

                Dispatcher.get().dispatch(new CreateListItemEndEvent(listItemData));
            }

            @Override
            public void onFailure(Throwable caught) {
                Dispatcher.get().dispatch(new ErrorEvent(caught));
            }

        });
    }

    private void updateListItem(List<ListItemModelData> listItemDataList) {
        this.listRepositoryService.updateListItem(listItemDataList, new AsyncCallback<List<ListItemModelData>>() {

            @Override
            public void onSuccess(List<ListItemModelData> updatedListItemDataList) {
                List<ListItemModelData> listItemDataList = RegistryUtil.getListItemList();
                for (ListItemModelData updatedListItemData : updatedListItemDataList) {
                    for (ListItemModelData listItemData : listItemDataList) {
                        if (listItemData.getId().equals(updatedListItemData.getId())) {
                            listItemData.update(updatedListItemData);
                            break;
                        }
                    }
                }

                Dispatcher.get().dispatch(new UpdateListItemEndEvent(updatedListItemDataList));
            }

            @Override
            public void onFailure(Throwable caught) {
                Dispatcher.get().dispatch(new ErrorEvent(caught));
            }

        });
    }

    private void deleteListItem(final List<ListItemModelData> deleteListItemDataList) {
        this.listRepositoryService.deleteListItem(deleteListItemDataList, new AsyncCallback<Void>() {

            @Override
            public void onSuccess(Void result) {
                List<ListItemModelData> listItemDataList = RegistryUtil.getListItemList();
                for (ListItemModelData deleteListItemData : deleteListItemDataList) {
                    for (Iterator<ListItemModelData> ite = listItemDataList.iterator(); ite.hasNext();) {
                        ListItemModelData listItemData = ite.next();

                        if (deleteListItemData.getId().equals(listItemData.getId())) {
                            ite.remove();
                            break;
                        }
                    }
                }

                Dispatcher.get().dispatch(new DeleteListItemEndEvent(deleteListItemDataList));
            }

            @Override
            public void onFailure(Throwable caught) {
                Dispatcher.get().dispatch(new ErrorEvent(caught));
            }

        });
    }

}
