
package jp.gr.java_conf.u6k.simple_checklist.gwt.client.controller;

import jp.gr.java_conf.u6k.simple_checklist.gwt.client.event.ErrorEvent;

import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.core.client.GWT;

public abstract class AbstractController extends Controller {

    public AbstractController() {
        this.registerEventTypes(ErrorEvent.TYPE);
    }

    @Override
    public void handleEvent(AppEvent event) {
        if (event.getType() == ErrorEvent.TYPE) {
            ErrorEvent ev = (ErrorEvent) event;

            Throwable caught = ev.getCaught();

            GWT.log(null, caught);

            MessageBox mb = new MessageBox();
            mb.setIcon(MessageBox.ERROR);
            mb.setMessage("エラーが発生しました。システムが正常に動作していない可能性があります。<br>" + caught.toString());
            mb.setTitle("エラー");
            mb.show();

        } else {
            MessageBox mb = new MessageBox();
            mb.setIcon(MessageBox.ERROR);
            mb.setMessage("エラーが発生しました。認識できないイベントです。<br>code: " + event.getType().getEventCode());
            mb.setTitle("エラー");
            mb.show();

        }
    }

}
