using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Plugin;

namespace TypingManager
{
    public class KeyState : Plugin.IKeyState
    {
        // Ă邩 <ĂL[R[h, l͎gȂ>
        private Dictionary<int, int> down_key = new Dictionary<int, int>();

        // O񉟂ĂL[
        private int last_down = 0;

        // ЂƂOɉĂL[
        private int down = 0;

        // ЂƂOɗꂽL[
        private int up = 0;

        // OKeyDownKeyUpŌĂ΂ꂽL[R[h
        private int called_key = 0;

        // called_keỹL[
        private string called_key_name = "";

        private const int VK_LMENU = (int)Keys.LMenu;
        private const int VK_RMENU = (int)Keys.RMenu;
        private const int VK_MENU = (int)Keys.Menu;
        private const int VK_LSHIFT = (int)Keys.LShiftKey;
        private const int VK_RSHIFT = (int)Keys.RShiftKey;
        private const int VK_SHIFT = (int)Keys.ShiftKey;
        private const int VK_LCTRL = (int)Keys.LControlKey;
        private const int VK_RCTRL = (int)Keys.RControlKey;
        private const int VK_CTRL = (int)Keys.ControlKey;

        public int KeyCode
        {
            get { return called_key; }
        }
        public string KeyName
        {
            get { return called_key_name; }
        }
        public int UpKey
        {
            get { return up; }
        }
        public int DownKey
        {
            get { return down; }
        }

        public void KeyDown(int keycode)
        {
            down = keycode;
            called_key = keycode;
            called_key_name = VirtualKeyName.GetKeyName(keycode);
            down_key[keycode] = 1;
        }

        public void KeyUp(int keycode)
        {
            if (down_key.ContainsKey(keycode))
            {
                down_key.Remove(keycode);
            }
            if (keycode == last_down)
            {
                last_down = 0;
            }
            up = keycode;
            called_key = keycode;
            called_key_name = VirtualKeyName.GetKeyName(keycode);
        }

        /// <summary>
        /// 񉟂ꂽۂɑĉĂ̂CVꂽ̂
        /// Ԃ߂ɁCeL[̏IĂĂ΂
        /// ỎꂽL[̏Ԃۑ
        /// </summary>
        public void SetDownState()
        {
            last_down = down;   
        }

        public bool IsDown(Keys key)
        {
            return down_key.ContainsKey((int)key);
        }

        public bool IsDown(int keycode)
        {
            return down_key.ContainsKey(keycode);
        }

        public bool IsLastDown(Keys key)
        {
            return (int)key == last_down;
        }

        public bool IsLastDown(int keycode)
        {
            return keycode == last_down;
        }

        public bool IsPush(Keys key)
        {
            return IsDown(key) && !IsLastDown(key);
        }

        public bool IsPush(int keycode)
        {
            return IsDown(keycode) && !IsLastDown(keycode);
        }

        public bool IsAlt
        {
            get { return IsDown(VK_LMENU) || IsDown(VK_RMENU) || IsDown(VK_MENU); }
        }

        public bool IsControl
        {
            get { return IsDown(VK_LCTRL) || IsDown(VK_RCTRL) || IsDown(VK_CTRL); }
        }

        public bool IsShift
        {
            get { return IsDown(VK_LSHIFT) || IsDown(VK_RSHIFT) || IsDown(VK_SHIFT); }
        }
    }
}
