#ifndef TSREMUXCPP_TSTOPES_H_
#define TSREMUXCPP_TSTOPES_H_

#include "Utils.h"

namespace TsRemux {
class TsIo {
 public:
  TsIo(FileStream read, FileStream write);
  TsIo(FileStream read, FileStream write, Int32 buffersize);
  void init(FileStream read, FileStream write, Int32 buffersize);
  int Read(pByte target, int offset, int count);
  void Write(pByte target, int offset, int count);
  void Flush(void);
  void Clear(void);
 protected:
 private:
  FileStream fsr;
  FileStream fsw;
  pByte ReadBuffer1;
  pByte ReadBuffer2;
  pByte ReadBuffer;
  pByte WriteBuffer1;
  pByte WriteBuffer2;
  pByte WriteBuffer;
  Int64 readIndex;
  Int64 readSize;
  Int64 writeIndex;
  IAsyncResult asyncRead;
  IAsyncResult asyncWrite;
};
class PesFile {
 public:
  void SetPcrDelegate(PcrChanged pcr);
  Int64 StartPcr;
  Int64 EndPcr;
  void SetPtsDelegate(PtsChanged pts);
  StreamInfo GetStreamInfo(ushort pid);
  void CloseFile(void);
  void Clear(void);
  TsFileType GetFileType(FileStream fs)throw(std::invalid_argument);
  std::vector<boost::shared_ptr<StreamInfo> > StreamInfos;
  TimeSpan VideoLength;
  boost::shared_ptr<PesPacket> GetNextPesPackets(void);
  void Seek(Int64 pcr);
  DTCP_Descriptor DtcpInfo;
 protected:
  PesFile(BackgroundWorker openWorker);
  void ReportProgress(Int32 percent);
  void GetInitialValues(void);
  FileStream fs;
  TsIo tsior;
  TsFileType fileTpe;
  Int64 startPcr;
  Int64 endPcr;
  std::vector<boost::shared_ptr<StreamInfo> > sis;
  PcrChanged pcrDelegate;
  PtsChanged ptsDelegate;
  BackgroundWorker openWorker;
  Int32 lastPercent;
 private:
  void ParseElementaryStreams(void);
  void ParseStream(StreamInfo si, pByte payload);
  static PesFile OpenFile(std::string path, bool useAsync, BackgroundWorker openWorker);
};

class EvoPesFile {
 public:
  EvoPesFile(BackgroundWorker bw);
  DTCP_Descriptor DtcpInfo;
  PesPacket* GetNextPesPackets(void);
  void Seek(signed long pcr);
 protected:
  void GetInitialValues(void);
 private:
  Dictionary<ushort, pByte> soundFrames;
  Int64 GetCurrentPcrFromFile(void);
  void GetTimeStamps(void);
  char GetVC1SubstreamId(pByte buff, Int32 offset);
  Int64 lastPcr;
};

class SupPesFile {
 public:
  SupPesFile(BackgroundWorker bw);
  DTCP_Descriptor DtcpInfo;
  boost::shared_ptr<PesPacket> GetNextPesPackets(void);
  void Seek(Int32 pcr);
 protected:
  void GetInitialValues(void);
 private:
  Int64 GetCurrentPcrFromFile(void);
  void GetTimeStamps(void);
};

class TsPesFile {
 public:
  TsPesFile(BackgroundWorker bw);
  DTCP_Descriptor DtcpInfo;
  boost::shared_ptr<PesPacket> GetNextPesPackets(void);
  void Seek(Int32 pcr);
 protected:
  void GetInitialValues(void);
 private:
  Int64 GetCurrentPcrFromFile(void);
  void GetTimeStamps(void);
  Int32 stride;
  pByte tsPack;
  Dictionary<ushort, PesPacket> PesPackets;
  DTCP_Descriptor dt;
  ushort pcrPID;
};
}
#endif
