#ifndef TSREMUXCPP_BLUEMUX_H_
#define TSREMUXCPP_BLUEMUX_H_

#include <string>
#include <list>

#include "Utils.h"
#include "TsToPes.h"
#include "define_temporary.h"
#include "define_stream.h"
#include "define_backgroundworker.h"

namespace TsRemux
{
// move to Utils.h
// struct EpElement {
//  public:
//   signed long long pts_;
//   unsigned long spn_;
//   EpElement(signed long long pts, unsigned long spn);
// };

class BlueMux {
 public:
  BlueMux(std::string filename, TsFileType fileType,
    std::list<StreamInfo> StreamsToKeep, bool fAsync,
    bool fProcessAudio, bool fMlpToAc3);
  unsigned int CurrentPacketNumber;
  EpElement EpData[];
  StreamInfo Psi;
  void MuxPacket(PesPacket pp);
  void PcrChanged(signed long long pcr);
  void Close(void);

 private:
  void CreatePsi(void);
  PesPacket* CheckAndFixDiscontinuities(PesPacket pp);
  void MuxPesPacketToTs(PesPacket pp, bool riority);
  void MuxTsPacket(PesPacket pp);
  void MuxAc3ToTs(PesPacket pp, ElementaryStreamTypes type);
  void MuxMlpToTs(PesPacket pp, ElementaryStreamTypes type);
  void MuxDtsToTs(PesPacket pp, ElementaryStreamTypes type);
  void MuxSingleAc3ToTs(char payload[], signed int offset,
    signed int len, signed long long pts,
    ElementaryStreamTypes type, unsigned short pid);
  void MuxSingleDtsToTs(char payload[], signed int offset,
    signed int len, signed long long pts,
    ElementaryStreamTypes type, unsigned short pid);
  ElementaryStreamTypes GetStreamType(unsigned short pid);
  TsFileType fileType;
  std::list<StreamInfo> StreamToKeep;
  TsIo tsiow;
  std::list<TsPacket> buffer;
  signed long long currentPcr;
  signed long long lastPcr;
  signed long long lastDelta;
  signed long long pcrOffset;
  signed long long currentPts;
  signed long long lastPts;
  signed long long ptsDelta;
  signed long long ptsOffset;
  signed long long ptsCount;
  Dictionary<unsigned short, unsigned short> pidMappings;
  char header[];
  Dictionary<unsigned short, char> Continuities;
  char supHeader[];
  FileStream fsw;
  char VideoType;
  PesPacket lastPacket;
  char sitCount;
  unsigned int packetCount;
  std::list<EpElement> epData;
  std::list<StreamInfo> pmtStreams;
  Dictionary<unsigned short, unsigned long long> lastPtsList;
  Dictionary<unsigned short, std::list<char> > soundFrames;
  bool processAudio;
  bool MlpToAc3; 
};

class Coodinator {
 public:
  Coodinator(void);
  void StartMuxing(std::string outPath, BackgroundWorker worker, TsFileType outType, std::list<unsigned short> pidsToKeep, time_t ts, time_t te, bool useAsync, PesFile input);
  void StartMuxing(std::string outPath, BackgroundWorker worker, TsFileType outType, std::list<unsigned short> pidsToKeep, time_t ts, time_t te, bool useAsync, bool processAudio, bool MlpToAc3, PesFile input, PesFile secondry, time_t offset, time_t chapterLen);
  void UpdatePcr(signed long long pcr);
  void UpdatePts(signed long long pts, unsigned short pid);
  signed long long endTime;
  BackgroundWorker bw;
  bool done;
  signed long long seconds;
  bool subtitles;
  signed long long startOffset;

 private:
  PesFile inFile;
  BlueMux outFile;
};
}
#endif

