%define name senna
%define prefix /usr
%define version 1.1.4
%define release tritonn.1.0.12a

Name:      %{name}
Version:   %{version}
Release:   %{release}
Group:     Development/Library
Summary:   Embeddable fulltext search engine
License:   LGPL
URL:       http://qwik.jp/senna/
Source:    %{name}-%{version}.tar.gz
Packager:  Tritonn Project <http://qwik.jp/tritonn/>
BuildRoot: /tmp/%{name}-%{version}-root
Requires:  mecab mecab-ipadic

%description
Senna is an embeddable fulltext search engine, which you
can use in conjuction with various scripting languages
and databases.

%prep
%setup -q -n %{name}-%{version}

%build
CLFAGS="-g -O3" CXXFLAGS="-g -O3" \
./configure --prefix=%{prefix}
make

%install
[ -d $RPM_BUILD_ROOT ] && rm -fr $RPM_BUILD_ROOT
make -e prefix=${RPM_BUILD_ROOT}%{prefix} install

%clean
[ -d $RPM_BUILD_ROOT ] && rm -fr $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%{prefix}/lib/libsenna.a
%{prefix}/lib/libsenna.la
%{prefix}/lib/libsenna.so.0.0.0
%{prefix}/lib/libsenna.so.0
%{prefix}/lib/libsenna.so
%{prefix}/include/senna/senna.h
%{prefix}/bin/senna-cfg
%{prefix}/bin/sennachk
%{prefix}/bin/senna
%{prefix}/lib/pkgconfig/senna.pc


%changelog
* Thu Nov 26 2009 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> - 1.1.4-tritonn.1.0.12a
- Tritonn 1.0.12a

* Tue Dec 09 2008 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> - 1.1.4-tritonn.1.0.12
- Tritonn 1.0.12

* Fri Jun 13 2008 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> - 1.1.3-tritonn.1.0.10
- Added senna.pc to files section
- Tritonn 1.0.10

* Fri Feb 1 2008 Tetsuro IKEDA <ikdttr at gmail.com> - 1.1.0-tritonn.1.0.9
- Tritonn 1.0.9

* Tue Dec 18 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 1.0.9-tritonn.1.0.8
- Tritonn 1.0.8

* Tue Nov 06 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 1.0.9-tritonn.1.0.7a
- added "defattr" to files section.

* Mon Oct 29 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 1.0.9-tritonn.1.0.7
- Initial build.

