/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.apphosting.api.search.DocumentPb;

public final class DocumentChecker {
    public static final int MAXIMUM_DOCUMENT_ID_LENGTH = 500;
    public static final int MAXIMUM_DOCUMENT_LENGTH = 0x100000;

    public static String checkDocumentId(String documentId) {
        Preconditions.checkArgument(!Util.isNullOrEmpty(documentId), "Document id is null or empty");
        Preconditions.checkArgument(documentId.length() <= 500, "Document id is longer than %d: %s", 500, documentId);
        Preconditions.checkArgument(IndexChecker.isAsciiVisiblePrintable(documentId), "documentId must be ASCII visible printable: %s", documentId);
        Preconditions.checkArgument(!IndexChecker.isReserved(documentId), "documentId must not start with !: %s", documentId);
        return documentId;
    }

    public static DocumentPb.Document checkValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(pb.getSerializedSize() <= 0x100000, "Document length %d is greater than the maximum %d bytes", pb.getSerializedSize(), 0x100000);
        if (pb.hasId()) {
            DocumentChecker.checkDocumentId(pb.getId());
        }
        Preconditions.checkArgument(pb.getFieldList() != null, "Null list of fields in document for indexing");
        return pb;
    }
}

