/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.LiteralByteString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private int hash = 0;

    private RopeByteString(ByteString left, ByteString right) {
        this.left = left;
        this.right = right;
        this.leftLength = left.size();
        this.totalLength = this.leftLength + right.size();
        this.treeDepth = Math.max(left.getTreeDepth(), right.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString left, ByteString right) {
        ByteString result;
        RopeByteString leftRope;
        RopeByteString ropeByteString = leftRope = left instanceof RopeByteString ? (RopeByteString)left : null;
        if (right.size() == 0) {
            result = left;
        } else if (left.size() == 0) {
            result = right;
        } else {
            int newLength = left.size() + right.size();
            if (newLength < 128) {
                result = RopeByteString.concatenateBytes(left, right);
            } else if (leftRope != null && leftRope.right.size() + right.size() < 128) {
                LiteralByteString newRight = RopeByteString.concatenateBytes(leftRope.right, right);
                result = new RopeByteString(leftRope.left, newRight);
            } else if (leftRope != null && leftRope.left.getTreeDepth() > leftRope.right.getTreeDepth() && leftRope.getTreeDepth() > right.getTreeDepth()) {
                RopeByteString newRight = new RopeByteString(leftRope.right, right);
                result = new RopeByteString(leftRope.left, newRight);
            } else {
                int newDepth = Math.max(left.getTreeDepth(), right.getTreeDepth()) + 1;
                result = newLength >= minLengthByDepth[newDepth] ? new RopeByteString(left, right) : new Balancer().balance(left, right);
            }
        }
        return result;
    }

    private static LiteralByteString concatenateBytes(ByteString left, ByteString right) {
        int leftSize = left.size();
        int rightSize = right.size();
        byte[] bytes = new byte[leftSize + rightSize];
        left.copyTo(bytes, 0, 0, leftSize);
        right.copyTo(bytes, 0, leftSize, rightSize);
        return new LiteralByteString(bytes);
    }

    static RopeByteString newInstanceForTest(ByteString left, ByteString right) {
        return new RopeByteString(left, right);
    }

    public byte byteAt(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index < 0: " + index);
        }
        if (index > this.totalLength) {
            throw new ArrayIndexOutOfBoundsException("Index > length: " + index + ", " + this.totalLength);
        }
        byte result = index < this.leftLength ? this.left.byteAt(index) : this.right.byteAt(index - this.leftLength);
        return result;
    }

    public int size() {
        return this.totalLength;
    }

    protected int getTreeDepth() {
        return this.treeDepth;
    }

    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    public ByteString substring(int beginIndex, int endIndex) {
        ByteString result;
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Beginning index: " + beginIndex + " < 0");
        }
        if (endIndex > this.totalLength) {
            throw new IndexOutOfBoundsException("End index: " + endIndex + " > " + this.totalLength);
        }
        int substringLength = endIndex - beginIndex;
        if (substringLength < 0) {
            throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + beginIndex + ", " + endIndex);
        }
        if (substringLength == 0) {
            result = ByteString.EMPTY;
        } else if (substringLength == this.totalLength) {
            result = this;
        } else if (endIndex <= this.leftLength) {
            result = this.left.substring(beginIndex, endIndex);
        } else if (beginIndex >= this.leftLength) {
            result = this.right.substring(beginIndex - this.leftLength, endIndex - this.leftLength);
        } else {
            ByteString leftSub = this.left.substring(beginIndex);
            ByteString rightSub = this.right.substring(0, endIndex - this.leftLength);
            result = new RopeByteString(leftSub, rightSub);
        }
        return result;
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("Source offset < 0: " + sourceOffset);
        }
        if (targetOffset < 0) {
            throw new IndexOutOfBoundsException("Target offset < 0: " + targetOffset);
        }
        if (numberToCopy < 0) {
            throw new IndexOutOfBoundsException("Length < 0: " + numberToCopy);
        }
        if (numberToCopy == 0) {
            return;
        }
        int endIndex = sourceOffset + numberToCopy;
        if (endIndex <= this.leftLength) {
            this.left.copyTo(target, sourceOffset, targetOffset, numberToCopy);
        } else if (sourceOffset >= this.leftLength) {
            this.right.copyTo(target, sourceOffset - this.leftLength, targetOffset, numberToCopy);
        } else {
            int leftLength = this.leftLength - sourceOffset;
            this.left.copyTo(target, sourceOffset, targetOffset, leftLength);
            this.right.copyTo(target, 0, targetOffset + leftLength, numberToCopy - leftLength);
        }
    }

    public void copyTo(ByteBuffer target) {
        target.put(this.toByteArray());
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.totalLength];
        this.copyTo(result, 0, 0, this.totalLength);
        return result;
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), charsetName);
    }

    public boolean isValidUtf8() {
        int leftPartial = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        int state = this.right.partialIsValidUtf8(leftPartial, 0, this.right.size());
        return state == 0;
    }

    protected int partialIsValidUtf8(int state, int offset, int length) {
        int toIndex = offset + length;
        if (toIndex <= this.leftLength) {
            return this.left.partialIsValidUtf8(state, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialIsValidUtf8(state, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialIsValidUtf8(state, offset, leftLength);
        return this.right.partialIsValidUtf8(leftPartial, 0, length - leftLength);
    }

    public boolean equals(Object other) {
        int cachedOtherHash;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherByteString = (ByteString)other;
        if (this.totalLength != otherByteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        if (this.hash != 0 && (cachedOtherHash = otherByteString.peekCachedHashCode()) != 0 && this.hash != cachedOtherHash) {
            return false;
        }
        return this.equalsFragments(otherByteString);
    }

    private boolean equalsFragments(ByteString other) {
        int thisOffset = 0;
        PieceIterator thisIter = new PieceIterator(this);
        LiteralByteString thisString = (LiteralByteString)thisIter.next();
        int thatOffset = 0;
        PieceIterator thatIter = new PieceIterator(other);
        LiteralByteString thatString = (LiteralByteString)thatIter.next();
        int pos = 0;
        while (true) {
            boolean stillEqual;
            int thisRemaining = thisString.size() - thisOffset;
            int thatRemaining = thatString.size() - thatOffset;
            int bytesToCompare = Math.min(thisRemaining, thatRemaining);
            boolean bl = stillEqual = thisOffset == 0 ? thisString.equalsRange(thatString, thatOffset, bytesToCompare) : thatString.equalsRange(thisString, thisOffset, bytesToCompare);
            if (!stillEqual) {
                return false;
            }
            if ((pos += bytesToCompare) >= this.totalLength) {
                if (pos == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (bytesToCompare == thisRemaining) {
                thisOffset = 0;
                thisString = (LiteralByteString)thisIter.next();
            } else {
                thisOffset += bytesToCompare;
            }
            if (bytesToCompare == thatRemaining) {
                thatOffset = 0;
                thatString = (LiteralByteString)thatIter.next();
                continue;
            }
            thatOffset += bytesToCompare;
        }
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.totalLength;
            if ((h = this.partialHash(h, 0, this.totalLength)) == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }

    protected int peekCachedHashCode() {
        return this.hash;
    }

    protected int partialHash(int h, int offset, int length) {
        int toIndex = offset + length;
        if (toIndex <= this.leftLength) {
            return this.left.partialHash(h, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialHash(h, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialHash(h, offset, leftLength);
        return this.right.partialHash(leftPartial, 0, length - leftLength);
    }

    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.toByteArray());
    }

    public InputStream newInput() {
        return new ByteArrayInputStream(this.toByteArray());
    }

    public ByteString.ByteIterator iterator() {
        return new RopeByteIterator();
    }

    static {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int f1 = 1;
        int f2 = 1;
        while (f2 > 0) {
            numbers.add(f2);
            int temp = f1 + f2;
            f1 = f2;
            f2 = temp;
        }
        numbers.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[numbers.size()];
        for (int i = 0; i < minLengthByDepth.length; ++i) {
            RopeByteString.minLengthByDepth[i] = (Integer)numbers.get(i);
        }
    }

    private class RopeByteIterator
    implements ByteString.ByteIterator {
        private final PieceIterator pieces;
        private ByteString.ByteIterator bytes;
        int bytesRemaining;

        private RopeByteIterator() {
            this.pieces = new PieceIterator(RopeByteString.this);
            this.bytes = this.pieces.next().iterator();
            this.bytesRemaining = RopeByteString.this.size();
        }

        public boolean hasNext() {
            return this.bytesRemaining > 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            while (!this.bytes.hasNext()) {
                this.bytes = this.pieces.next().iterator();
            }
            --this.bytesRemaining;
            return this.bytes.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PieceIterator
    implements Iterator<LiteralByteString> {
        private final Deque<RopeByteString> breadCrumbs = new ArrayDeque<RopeByteString>(RopeByteString.access$300().length);
        private LiteralByteString next;

        private PieceIterator(ByteString root) {
            this.next = this.getLeafByLeft(root);
        }

        private LiteralByteString getLeafByLeft(ByteString root) {
            ByteString pos = root;
            while (pos instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)pos;
                this.breadCrumbs.push(rbs);
                pos = rbs.left;
            }
            return (LiteralByteString)pos;
        }

        private LiteralByteString getNextLeaf() {
            return !this.breadCrumbs.isEmpty() ? this.getLeafByLeft(this.breadCrumbs.pop().right) : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public LiteralByteString next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LiteralByteString result = this.next;
            this.next = this.getNextLeaf();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final Deque<ByteString> prefixesStack = new ArrayDeque<ByteString>(RopeByteString.access$300().length);

        private Balancer() {
        }

        private ByteString balance(ByteString left, ByteString right) {
            this.doBalance(left);
            this.doBalance(right);
            ByteString partialString = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                ByteString newLeft = this.prefixesStack.pop();
                partialString = new RopeByteString(newLeft, partialString);
            }
            return partialString;
        }

        private void doBalance(ByteString root) {
            if (root.isBalanced()) {
                this.insert(root);
            } else if (root instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)root;
                this.doBalance(rbs.left);
                this.doBalance(rbs.right);
            } else {
                throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + root.getClass());
            }
        }

        private void insert(ByteString byteString) {
            int depthBin = this.getDepthBinForLength(byteString.size());
            int binEnd = minLengthByDepth[depthBin + 1];
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= binEnd) {
                this.prefixesStack.push(byteString);
            } else {
                ByteString left;
                int binStart = minLengthByDepth[depthBin];
                ByteString newTree = this.prefixesStack.pop();
                while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < binStart) {
                    left = this.prefixesStack.pop();
                    newTree = new RopeByteString(left, newTree);
                }
                newTree = new RopeByteString(newTree, byteString);
                while (!this.prefixesStack.isEmpty()) {
                    depthBin = this.getDepthBinForLength(newTree.size());
                    binEnd = minLengthByDepth[depthBin + 1];
                    if (this.prefixesStack.peek().size() >= binEnd) break;
                    left = this.prefixesStack.pop();
                    newTree = new RopeByteString(left, newTree);
                }
                this.prefixesStack.push(newTree);
            }
        }

        private int getDepthBinForLength(int length) {
            int depth = Arrays.binarySearch(minLengthByDepth, length);
            if (depth < 0) {
                int insertionPoint = -(depth + 1);
                depth = insertionPoint - 1;
            }
            return depth;
        }
    }
}

