/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.LiteralByteString;
import com.google.appengine.repackaged.com.google.protobuf.RopeByteString;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteString
implements Iterable<Byte> {
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    public static final ByteString EMPTY = new LiteralByteString(new byte[0]);

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    public abstract ByteIterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public ByteString substring(int beginIndex) {
        return this.substring(beginIndex, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(bytes, offset, copy, 0, size);
        return new LiteralByteString(copy);
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    public static ByteString copyFrom(ByteBuffer bytes, int size) {
        byte[] copy = new byte[size];
        bytes.get(copy);
        return new LiteralByteString(copy);
    }

    public static ByteString copyFrom(ByteBuffer bytes) {
        return ByteString.copyFrom(bytes, bytes.remaining());
    }

    public static ByteString copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        return new LiteralByteString(text.getBytes(charsetName));
    }

    public static ByteString copyFromUtf8(String text) {
        try {
            return new LiteralByteString(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public ByteString concat(ByteString other) {
        int otherSize;
        int thisSize = this.size();
        if ((long)thisSize + (long)(otherSize = other.size()) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ByteString would be too long: " + thisSize + "+" + otherSize);
        }
        return RopeByteString.concatenate(this, other);
    }

    public static ByteString copyFrom(Iterable<ByteString> iterable) {
        ByteString result;
        Iterator<ByteString> iter = iterable.iterator();
        if (!iter.hasNext()) {
            result = EMPTY;
        } else {
            while (true) {
                ArrayList<ByteString> toList = new ArrayList<ByteString>();
                while (iter.hasNext()) {
                    ByteString left = iter.next();
                    if (iter.hasNext()) {
                        ByteString right = iter.next();
                        toList.add(left.concat(right));
                        continue;
                    }
                    toList.add(left);
                }
                int toListSize = toList.size();
                if (toListSize == 1) {
                    result = (ByteString)toList.get(0);
                    break;
                }
                iter = toList.iterator();
            }
        }
        return result;
    }

    public void copyTo(byte[] target, int offset) {
        this.copyTo(target, 0, offset, this.size());
    }

    public abstract void copyTo(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    public abstract byte[] toByteArray();

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract String toString(String var1) throws UnsupportedEncodingException;

    public String toStringUtf8() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput(int initialCapacity) {
        return new Output(new ByteArrayOutputStream(initialCapacity));
    }

    public static Output newOutput() {
        return ByteString.newOutput(32);
    }

    static CodedBuilder newCodedBuilder(int size) {
        return new CodedBuilder(size);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected abstract int peekCachedHashCode();

    protected abstract int partialHash(int var1, int var2, int var3);

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int size) {
            this.buffer = new byte[size];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            return new LiteralByteString(this.buffer);
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends FilterOutputStream {
        private final ByteArrayOutputStream bout;

        private Output(ByteArrayOutputStream bout) {
            super(bout);
            this.bout = bout;
        }

        public ByteString toByteString() {
            byte[] byteArray = this.bout.toByteArray();
            return new LiteralByteString(byteArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }
}

