/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;

public class ListDocumentsRequestChecker {
    public static final int MAXIMUM_LIMIT = 1000;
    public static final int DEFAULT_LIMIT = 100;

    public static int checkLimit(int limit) {
        Preconditions.checkArgument(limit >= 0 && limit <= 1000, String.format("The limit %d must be between 0 and %d", limit, 1000));
        return limit;
    }

    public static String checkStartDocId(String startDocId) {
        if (Util.isNullOrEmpty(startDocId)) {
            return startDocId;
        }
        return DocumentChecker.checkDocumentId(startDocId);
    }

    public static SearchServicePb.ListDocumentsParams checkListDocumentsParams(SearchServicePb.ListDocumentsParams params) {
        IndexChecker.checkName(params.getIndexSpec().getName());
        if (params.hasLimit()) {
            ListDocumentsRequestChecker.checkLimit(params.getLimit());
        }
        if (params.hasStartDocId()) {
            DocumentChecker.checkDocumentId(params.getStartDocId());
        }
        return params;
    }
}

