/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.ConversionOptions;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

public final class Conversion {
    private final Document input;
    private final String outputMimeType;
    private final ConversionOptions options;

    public Conversion(Document input, String outputMimeType) {
        this(input, outputMimeType, ConversionOptions.Builder.withDefaults());
    }

    public Conversion(Document input, String outputMimeType, ConversionOptions options) {
        this.input = Preconditions.checkNotNull(input);
        this.outputMimeType = Preconditions.checkNotNull(outputMimeType).toLowerCase();
        this.options = Preconditions.checkNotNull(options);
    }

    public Document getInputDoc() {
        return this.input;
    }

    public String getOutputMimeType() {
        return this.outputMimeType;
    }

    public ConversionOptions getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversion other = (Conversion)o;
        return Objects.equal(this.input, other.getInputDoc()) && Objects.equal(this.outputMimeType, other.getOutputMimeType()) && Objects.equal(this.options, other.getOptions());
    }

    public int hashCode() {
        return Objects.hashCode(this.input, this.outputMimeType, this.options);
    }
}

