/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jdo;

import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.TransactionOptions;
import javax.jdo.PersistenceManager;
import org.datanucleus.Transaction;
import org.datanucleus.jdo.JDOTransaction;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.util.NucleusLogger;

class DatastoreJDOTransaction
extends JDOTransaction {
    private final DatastoreServiceConfig config;
    private final TransactionOptions txnOpts;

    public DatastoreJDOTransaction(PersistenceManager pm, DatastoreManager storeMgr, Transaction tx) {
        super(pm, tx);
        this.config = storeMgr.getDefaultDatastoreServiceConfigForWrites();
        this.txnOpts = storeMgr.getDefaultDatastoreTransactionOptions();
    }

    public void begin() {
        super.begin();
        com.google.appengine.api.datastore.Transaction txn = DatastoreServiceFactoryInternal.getDatastoreService(this.config).beginTransaction(this.txnOpts);
        NucleusLogger.DATASTORE.debug((Object)("Started new datastore transaction: " + txn.getId()));
    }

    public void commit() {
        super.commit();
        com.google.appengine.api.datastore.Transaction txn = DatastoreServiceFactoryInternal.getDatastoreService(this.config).getCurrentTransaction(null);
        if (txn != null) {
            txn.commit();
        }
    }

    public void rollback() {
        super.rollback();
        com.google.appengine.api.datastore.Transaction txn = DatastoreServiceFactoryInternal.getDatastoreService(this.config).getCurrentTransaction(null);
        if (txn != null) {
            txn.rollback();
        }
    }
}

