/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AbstractServerConnection;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.util.ClientCookieManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class ClientLoginServerConnection
extends AbstractServerConnection {
    protected ClientCookieManager cookies;

    public ClientLoginServerConnection(AppAdminFactory.ConnectOptions options) {
        super(options);
        this.cookies = options.getCookies();
        if (this.cookies == null) {
            this.cookies = new ClientCookieManager();
        }
    }

    private void authenticate(String host, String account_type) throws ClientLoginException, IOException {
        int unused = 1;
        while (true) {
            try {
                String authToken = this.getAuthToken(host, account_type);
                this.getAuthCookie(authToken);
                return;
            }
            catch (ClientLoginException e) {
                if (unused >= 3) {
                    throw e;
                }
                ++unused;
                continue;
            }
            break;
        }
    }

    protected void doHandleSendErrors(int status, URL url, HttpURLConnection conn, BufferedReader connReader) throws IOException {
        if (status == 401) {
            this.authenticate(url.getHost(), null);
        } else if (status == 403) {
            System.out.println(this.constructHttpErrorMessage(conn, connReader));
            this.authenticate(url.getHost(), null);
        } else if ((status < 500 || status > 600) && status == 302) {
            Map<String, List<String>> headers = conn.getHeaderFields();
            String location = headers.get("Location").get(0);
            if (location.startsWith("https://www.google.com/accounts/ServiceLogin")) {
                this.authenticate(url.getHost(), null);
            } else if (location.matches("https://www.google.com/a/[a-z0-9.-]+/ServiceLogin.*")) {
                this.authenticate(url.getHost(), "HOSTED");
            }
        }
    }

    protected void doPostConnect(String method, HttpURLConnection conn, AbstractServerConnection.DataPoster data) throws IOException {
        this.cookies.readCookies(conn);
        this.saveCookies();
    }

    protected void doPreConnect(String method, HttpURLConnection conn, AbstractServerConnection.DataPoster data) {
        this.cookies.writeCookies(conn);
    }

    private void getAuthCookie(String token) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("continue", "http://localhost/");
        params.put("auth", token);
        String query = this.buildQuery(params);
        URL url = this.buildURL("/_ah/login?" + query);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.options.getHost() != null) {
            conn.setRequestProperty("Host", this.options.getHost());
        }
        IOException ioe = this.connect("POST", conn, null);
        if (conn.getResponseCode() != 302 || !"http://localhost/".equals(conn.getHeaderField("Location"))) {
            throw new RuntimeException("Bad authentication response: " + conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private String getAuthToken(String host, String accountType) throws IOException, ClientLoginException {
        if (accountType == null) {
            accountType = host.endsWith(".google.com") ? "HOSTED_OR_GOOGLE" : (this.options.getHost() != null && this.options.getHost().endsWith(".google.com") ? "HOSTED_OR_GOOGLE" : "GOOGLE");
        }
        URL url = new URL("https://www.google.com/accounts/ClientLogin");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String password = this.options.getPasswordPrompt().getPassword();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Email", this.options.getUserId());
        params.put("Passwd", password);
        params.put("service", "ah");
        params.put("source", "Google-appcfg-java-unknown");
        params.put("accountType", accountType);
        IOException ioe = this.connect("POST", conn, new AbstractServerConnection.StringPoster(this.buildQuery(params)));
        BufferedReader reader = this.getReader(conn);
        HashMap<String, String> response = new HashMap<String, String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] pair = line.split("=", 2);
            if (pair.length != 2) continue;
            response.put(pair[0], pair[1]);
        }
        if (conn.getResponseCode() == 200) {
            return (String)response.get("Auth");
        }
        if (conn.getResponseCode() == 403) {
            String reason = (String)response.get("Error");
            if ("BadAuthentication".equals(reason)) {
                String info = (String)response.get("Info");
                if ("InvalidSecondFactor".equals(info)) {
                    throw new ClientLoginException("Use an application-specific password instead of your regular account password. See http://www.google.com/support/accounts/bin/answer.py?answer=185833", ioe);
                }
                throw new ClientLoginException("Email \"" + this.options.getUserId() + "\" and password do not match.", ioe);
            }
            if ("CaptchaRequired".equals(reason)) {
                throw new ClientLoginException("Please go to https://www.google.com/accounts/DisplayUnlockCaptcha and verify you are a human. Then try again.");
            }
            if ("NotVerified".equals(reason)) {
                throw new ClientLoginException("Your account has not yet been verfied. Please check your email to do that, then try again.");
            }
            if ("TermsNotAgreed".equals(reason)) {
                throw new ClientLoginException("You have not yet agreed to the Terms of Service on your account. Please do that, then try again.");
            }
            if ("AccountDeleted".equals(reason)) {
                throw new ClientLoginException("Your user account has been deleted. If this is an error, contact account support at http://www.google.com/support/accounts/");
            }
            if ("AccountDisabled".equals(reason)) {
                throw new ClientLoginException("Your user account has been disabled. If this is an error, contact account support at http://www.google.com/support/accounts/");
            }
            if ("ServiceUnavailable".equals(reason)) {
                throw new ClientLoginException("The service is currently unavailable; try again later.");
            }
            throw new ClientLoginException((String)response.get("Error"), ioe);
        }
        if (conn.getResponseCode() == 401) {
            throw new ClientAuthFailException("Email \"" + this.options.getUserId() + "\" and password do not match.", ioe);
        }
        throw new RuntimeException("Bad authentication response: " + conn.getResponseCode() + " " + conn.getResponseMessage(), ioe);
    }

    public void saveCookies() throws IOException {
        if (this.options.getUserId() == null) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new ObjectOutputStream(out).writeObject(this.cookies);
        byte[] bytes = out.toByteArray();
        Preferences prefs = Preferences.userNodeForPackage(ServerConnection.class);
        prefs.put("email", this.options.getUserId());
        prefs.putByteArray("cookies", bytes);
    }

    public class ClientLoginException
    extends IOException {
        public ClientLoginException(String s) {
            super(s);
        }

        public ClientLoginException(String s, Throwable t) {
            super(s, t);
        }
    }

    public class ClientAuthFailException
    extends ClientLoginException {
        public ClientAuthFailException(String s) {
            super(s);
        }

        public ClientAuthFailException(String s, Throwable t) {
            super(s, t);
        }
    }
}

