/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Consistency;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.IndexChecker;

public class IndexSpec {
    private final String name;
    private final Consistency consistency;

    private IndexSpec(Builder builder) {
        this.consistency = Util.defaultIfNull(builder.consistency, Consistency.PER_DOCUMENT);
        this.name = builder.name;
    }

    public String getName() {
        return this.name;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consistency == null ? 0 : this.consistency.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexSpec other = (IndexSpec)obj;
        if (this.consistency == null ? other.consistency != null : !this.consistency.equals((Object)other.consistency)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.format("IndexSpec{name: %s, consistency: %s}", this.name, this.consistency.name());
    }

    public static final class Builder {
        private String name;
        private Consistency consistency;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = IndexChecker.checkName(name);
            return this;
        }

        public Builder setConsistency(Consistency consistency) {
            this.consistency = consistency;
            return this;
        }

        public IndexSpec build() {
            return new IndexSpec(this);
        }
    }
}

