/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.util.ArrayList;

public final class TransactionOptions {
    private boolean xg = false;

    private TransactionOptions() {
    }

    TransactionOptions(TransactionOptions original) {
        this.xg = original.xg;
    }

    public TransactionOptions setXG(boolean enable) {
        this.xg = enable;
        return this;
    }

    public TransactionOptions clearXG() {
        this.xg = false;
        return this;
    }

    public boolean isXG() {
        return this.xg;
    }

    @Deprecated
    public TransactionOptions multipleEntityGroups(boolean enable) {
        return this.setXG(enable);
    }

    @Deprecated
    public TransactionOptions clearMultipleEntityGroups() {
        return this.clearXG();
    }

    @Deprecated
    public Boolean allowsMultipleEntityGroups() {
        return this.isXG();
    }

    public int hashCode() {
        int result = 0;
        result = result * 31 + (this.xg ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)obj;
        return this.xg == that.xg;
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("XG=" + this.xg);
        return "TransactionOptions" + result;
    }

    public static final class Builder {
        public static TransactionOptions withXG(boolean enable) {
            return Builder.withDefaults().setXG(enable);
        }

        @Deprecated
        public static TransactionOptions allowMultipleEntityGroups(boolean enable) {
            return Builder.withDefaults().setXG(enable);
        }

        public static TransactionOptions withDefaults() {
            return new TransactionOptions();
        }

        private Builder() {
        }
    }
}

