package com.td.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import twitter4j.AsyncTwitter;
import twitter4j.AsyncTwitterFactory;
import twitter4j.Query;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;

import com.td.R;
import com.td.TrainDelayedActivity;
import com.td.broadcast.DelayReceiver;
import com.td.db.DatabaseHelper;
import com.td.db.HistoryDao;
import com.td.db.Keyword;
import com.td.db.Train;
import com.td.utility.ConfUtil;
import com.td.utility.Const;
import com.td.utility.DateUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.ExceptionUtil;
import com.td.utility.NetworkUtil;
import com.td.utility.StatusFlag;
import com.td.utility.StatusFlagFactory;

public class TrainDelayedServiceImpl extends Service implements
		TrainDelayedService {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private StatusFlag tdSf = StatusFlagFactory.getInstance().getStatusFlag(
			this, StatusFlagFactory.Type.TRAIN_DELAY_SERVICE);
	private StatusFlag udSf = StatusFlagFactory.getInstance().getStatusFlag(
			this, StatusFlagFactory.Type.DB_UPDATE);

	private static final int NOTIFICATE_ID = 1;
	public static final String START_ACTION = "com.td.START";

	private final IBinder binder = new Binder();
	private static Scheduler scheduler = null;

	private static AsyncTwitterFactory factory = new AsyncTwitterFactory();
	private AsyncTwitter twitter = factory.getInstance();
	private TrainTwitterAdapter listener = new TrainTwitterAdapter(this);
	private String action = null;

	private static long id = 1;

	@Override
	public IBinder onBind(Intent intent) {
		return binder;
	}

	private void schedule(long delay) {
		try {
			Debug.d(this, "run() " + id);

			if (scheduler == null) {
				return;
			}
			List<Train> list = scheduler.getTrains();
			if (list == null) {
				return;
			}

			Calendar cal = Calendar.getInstance();
			listener.setCalender(cal);

			Query query;

			for (Train train : list) {
				String text = train.getSearchText();

				query = new Query();
				query.setRpp(Const.TWITTER_QUERY_MAX);
				query.setQuery(text);
				twitter.search(query);
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	public void notificate(String msg) {
		try {
			String ns = Context.NOTIFICATION_SERVICE;
			NotificationManager mNotificationManager = (NotificationManager) getSystemService(ns);

			int icon = R.drawable.icon;
			CharSequence tickerText = getString(R.string.ticker_nmsg);
			long when = System.currentTimeMillis();
			Notification notification = new Notification(icon, tickerText, when);

			Context context = getApplicationContext();
			CharSequence contentTitle = getString(R.string.content_title_nmsg);
			CharSequence contentText = msg;
			Intent notificationIntent = new Intent(this,
					TrainDelayedActivity.class);
			PendingIntent contentIntent = PendingIntent.getActivity(this, 0,
					notificationIntent, 0);
			notification.setLatestEventInfo(context, contentTitle, contentText,
					contentIntent);

			mNotificationManager.notify(NOTIFICATE_ID, notification);
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	@Override
	public void onCreate() {
		super.onCreate();

		Debug.d(this, Debug.ON_CREATE);
		twitter.addListener(listener);
	}

	private Runnable task = new Runnable() {
		public void run() {
			boolean flag = false;
			try {
				try {
					long now = System.currentTimeMillis();
					String action = TrainDelayedServiceImpl.this.action;
					
					Debug.d(this, "id=" + id);

					synchronized (binder) {
						try {
							if (udSf.isOn()) {
								scheduler = null;
								udSf.setOff();
							}

							if (scheduler == null) {
								scheduler = new Scheduler();
								DatabaseHelper.init(getApplicationContext());
							}
							scheduler.init();
							
							// lbg[NɐڑĂBANȊO
							if (NetworkUtil
									.isConnected(TrainDelayedServiceImpl.this)
									&& action.compareTo(START_ACTION) != 0) {
								ExceptionUtil.getInstance().throwException(
										ExceptionUtil.TAG_E40);
								schedule(-1);
							}
						} catch (Exception e) {
							Debug.t(TrainDelayedServiceImpl.this,
									e.getMessage());
							Debug.d(TrainDelayedServiceImpl.this, null, e);
						}
					}
					Calendar cal = Calendar.getInstance();
					cal.setTimeInMillis(now);
					Date nowDate = cal.getTime();

					ExceptionUtil.getInstance().throwException(
							ExceptionUtil.TAG_E41);

					int len = 0;
					if (action.compareTo(START_ACTION) != 0){
						len = ConfUtil.getLen(pref);						
					}
					long next = scheduler.calcSchedule(now, len);
					if (next < 0) {
						// N̐ݒ肪Ȃꍇ́AĎԊuŋN
						next = now + len * 60 * 1000;
					}
					String nextStr = DateUtil.formatted(next);
					Debug.t(TrainDelayedServiceImpl.this, "N " + nextStr);
					Debug.d(this, "N " + nextStr);

					// No^
					PendingIntent alarmSender = PendingIntent.getService(
							TrainDelayedServiceImpl.this, 0, new Intent(
									TrainDelayedServiceImpl.this,
									TrainDelayedServiceImpl.class), 0);
					AlarmManager alarm = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
					alarm.set(AlarmManager.RTC, next, alarmSender);
					flag = true;

					int nowYmd = DateUtil.getYmd(nowDate);
					cal.setTimeInMillis(next);
					Date date = cal.getTime();
					int ymd = DateUtil.getYmd(date);
					if (nowYmd != ymd) {
						HistoryDao dao = HistoryDao.getInstance();
						int ymd7 = DateUtil.getYmd(DateUtil.getTime(nowDate,
								-DateUtil.WEEK, 0).getTime());
						dao.deleteByYmd(TrainDelayedServiceImpl.this, ymd7);
						Debug.d(this, "폜 ymd < " + ymd7);
					}

					if (Debug.isDebug()) {
						int d = DateUtil.getD(ymd);
						int hm = DateUtil.getHm(date);

						long val = id * 100 * 10000 + d * 10000 + hm;

						TrainTwitterAdapter.insert(
								TrainDelayedServiceImpl.this,
								Calendar.getInstance(),
								TrainTwitterAdapter.START_ID, -1, val, -1);
					}

					if (action.compareTo(START_ACTION) == 0) {
						tdSf.setOn();

						// TODO
						Debug.l("TrainDelayedServiceImpl.run() tdSf.setOn() " + tdSf.toString());
						
						Intent intent = new Intent(DelayReceiver.START_SERVICE);
						TrainDelayedServiceImpl.this.sendBroadcast(intent);

						Debug.t(TrainDelayedServiceImpl.this, START_ACTION);
					}

					// T[rXI
					TrainDelayedServiceImpl.this.stopSelf();

					id = (id + 1) % 1000000;
				} catch (Exception e) {
					Debug.t(TrainDelayedServiceImpl.this, e.getMessage());
					Debug.d(this, null, e);
				}
			} finally {
				if (!flag) {
					tdSf.setOff();

					Intent intent = new Intent(DelayReceiver.STOP_SERVICE);
					TrainDelayedServiceImpl.this.sendBroadcast(intent);
				}
			}
		}
	};

	@Override
	public void onStart(Intent intent, int startId) {
		super.onStart(intent, startId);

		Debug.d(this, Debug.ON_START);

		action = intent.getAction();
		action = (action == null) ? "" : action;

		Thread thread = new Thread(null, task,
				TrainDelayedServiceImpl.class.getSimpleName());
		thread.start();
	}

	@Override
	public void onDestroy() {
		Debug.d(this, Debug.ON_DESTROY);

		super.onDestroy();
	}

	@Override
	public void onRebind(Intent intent) {
		super.onRebind(intent);

		Debug.d(this, Debug.ON_REBIND);
	}

	@Override
	public boolean onUnbind(Intent intent) {
		Debug.d(this, Debug.ON_UNBIND);

		super.onUnbind(intent);
		// ēxNCAgڑꂽۂ onRebind Ăяoꍇ true Ԃ
		return true;
	}

	public List<Keyword> getKeywords() {
		if (scheduler == null) {
			return null;
		}
		return scheduler.getKeywords();
	}

	public List<Train> getTrains() {
		if (scheduler == null) {
			return null;
		}
		return scheduler.getTrains();
	}

	public static void clearSchedule(Context context, EditPrefUtil pref) {
		StatusFlag udSf = StatusFlagFactory.getInstance().getStatusFlag(
				context, StatusFlagFactory.Type.DB_UPDATE);
		udSf.setOn();
	}

	public TrainDelayedServiceImpl getContext() {
		return this;
	}
}
