package com.td.db;

import java.util.Calendar;
import java.util.Date;

import com.td.utility.DateUtil;

public class Monitor {
	private long id;
	private boolean[] week;
	private int from;
	private int to;
	
	public Monitor(long id,  int from, int to){
		this.id = id;
		this.from = from;
		this.to = to;
		
		week = new boolean[DateUtil.WEEK];
		for (int i = 0; i < week.length; i++){
			week[i] = false;
		}
	}
	
	public Monitor(int from, int to){
		this(-1, from, to);
	}
	
	public static Monitor getMonitor(){
		Calendar cal = Calendar.getInstance();
		Date date = cal.getTime();
		int from = DateUtil.getHm(date);
		int to = DateUtil.getHm(date);

		return new Monitor(-1, from, to);
	}
	
	public boolean getWeek(int index) {
		return week[index];
	}

	public void setWeek(int index, boolean status) {
		week[index] = status;
	}

	public long getId() {
		return id;
	}

	public int getFrom() {
		return from;
	}

	public int getTo() {
		return to;
	}

	@Override
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append(DateUtil.formattedHm(from));
		sb.append(" - ");
		sb.append(DateUtil.formattedHm(to));
		sb.append(" ");
		for (int i = 0; i < week.length; i++){
			if (week[i]){
				sb.append(DateUtil.toName(i));				
			}
		}
		return sb.toString();
	}
}
