package com.td.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.td.utility.Debug;
import com.td.utility.Initialize;
import com.td.utility.TdException;

public class DatabaseHelper extends SQLiteOpenHelper {
	private static DatabaseHelper instance = null;

	public static DatabaseHelper getInstance() {
		return instance;
	}

	public static void init(Context context) throws TdException {
		if (instance != null) {
			return;
		}
		DatabaseHelper helper = new DatabaseHelper(context);
		SQLiteDatabase db = helper.getWritableDatabase();

		try {
			PrefectureDao.getInstance().start(db);
			TrainDao.getInstance().start(db);
			RelationDao.getInstance().start(db);
			KeywordDao.getInstance().start(db);
			MonitorDao.getInstance().start(db);
			LogDao.getInstance().start(db);
		}
		catch (Exception e){
			Debug.d(context, null, e);
		}
	}

	public DatabaseHelper(Context context) {
		super(context, "TrainDelayed.db", null, 1);
		instance = this;
	}

	public void initDB(SQLiteDatabase db, boolean isCreate){
		PrefectureDao prefectureDao = PrefectureDao.getInstance();
		TrainDao trainDao = TrainDao.getInstance();
		RelationDao relationDao = RelationDao.getInstance();
		KeywordDao keywordDao = KeywordDao.getInstance();
		MonitorDao monitorDao = MonitorDao.getInstance();
		LogDao logDao = LogDao.getInstance();

		try {
			if (isCreate){
				prefectureDao.onCreate(db);
				prefectureDao.start(db);
	
				trainDao.onCreate(db);
				trainDao.start(db);
	
				relationDao.onCreate(db);
				relationDao.start(db);
	
				keywordDao.onCreate(db);
				keywordDao.start(db);
	
				monitorDao.onCreate(db);
				monitorDao.start(db);
				
				logDao.onCreate(db);
				logDao.start(db);
			}
			
			db.beginTransaction();
			try {
				if (!isCreate){
					prefectureDao.deleteNT();
					trainDao.deleteNT();
					relationDao.deleteNT();
					keywordDao.deleteNT();
					monitorDao.deleteNT();				
					logDao.deleteNT();				
				}
				
				prefectureDao.init(db);
				trainDao.init(db);
				relationDao.init(db);
				keywordDao.init(db);
				monitorDao.init(db);
				logDao.init(db);

				db.setTransactionSuccessful();
			} finally {
				db.endTransaction();
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
		}		
	}
	
	@Override
	public void onCreate(SQLiteDatabase db) {
		initDB(db, true);
		
		Initialize.setInitialize();
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
	      //db.execSQL("drop table if exists " + TABLE_NAME);
          //onCreate(db);
	}
}
