package com.td;

import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;

import com.td.db.Log;
import com.td.db.LogDao;
import com.td.utility.BaseActivity;
import com.td.utility.Debug;

public class LogListActivity extends BaseActivity {
	private ListView listView;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.log_list);
		
		try {
			listView = (ListView) findViewById(R.id.menuc1);
			Button button1 = (Button) findViewById(R.id.buttonc1);
			Button button2 = (Button) findViewById(R.id.buttonc2);
			
			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view, int position,
						long id) {
					;
				}
			});
			
			button1.setOnClickListener(new OnClickListener(){
				public void onClick(View view) {
					LogDao.getInstance().delete();
					updateList();
				}});
			
			button2.setOnClickListener(new OnClickListener(){
				public void onClick(View view) {
					finish();
				}});

			updateList();			
		}
		catch (Exception e){
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}
	
	private void updateList(){
		final List<Log> list = LogDao.getInstance().search();
		ArrayAdapter<Log> adapter = new ArrayAdapter<Log>(this,
				R.layout.small_list_item_1, list);
		listView.setAdapter(adapter);
	}
}
