/*
 * Decompiled with CFR 0.152.
 */
package org.afree.ui;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.afree.graphics.geom.RectShape;

public final class RectangleEdge
implements Serializable {
    private static final long serialVersionUID = -1825115650717787617L;
    public static final RectangleEdge TOP = new RectangleEdge("RectangleEdge.TOP");
    public static final RectangleEdge BOTTOM = new RectangleEdge("RectangleEdge.BOTTOM");
    public static final RectangleEdge LEFT = new RectangleEdge("RectangleEdge.LEFT");
    public static final RectangleEdge RIGHT = new RectangleEdge("RectangleEdge.RIGHT");
    private String name;

    private RectangleEdge(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RectangleEdge)) {
            return false;
        }
        RectangleEdge order = (RectangleEdge)o;
        return this.name.equals(order.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static boolean isTopOrBottom(RectangleEdge edge) {
        return edge == TOP || edge == BOTTOM;
    }

    public static boolean isLeftOrRight(RectangleEdge edge) {
        return edge == LEFT || edge == RIGHT;
    }

    public static RectangleEdge opposite(RectangleEdge edge) {
        RectangleEdge result = null;
        if (edge == TOP) {
            result = BOTTOM;
        } else if (edge == BOTTOM) {
            result = TOP;
        } else if (edge == LEFT) {
            result = RIGHT;
        } else if (edge == RIGHT) {
            result = LEFT;
        }
        return result;
    }

    public static double coordinate(RectShape rectShape, RectangleEdge edge) {
        double result = 0.0;
        if (edge == TOP) {
            result = rectShape.getMinY();
        } else if (edge == BOTTOM) {
            result = rectShape.getMaxY();
        } else if (edge == LEFT) {
            result = rectShape.getMinX();
        } else if (edge == RIGHT) {
            result = rectShape.getMaxX();
        }
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        RectangleEdge result = null;
        if (this.equals(TOP)) {
            result = TOP;
        } else if (this.equals(BOTTOM)) {
            result = BOTTOM;
        } else if (this.equals(LEFT)) {
            result = LEFT;
        } else if (this.equals(RIGHT)) {
            result = RIGHT;
        }
        return result;
    }
}

