/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class RoundRectShape
implements Shape {
    private RectF mRect;
    private float mRX;
    private float mRY;
    private Path mPath;
    private Region mRegion;
    private RectF rectBuffer = new RectF();

    public RoundRectShape() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public RoundRectShape(float x, float y, float width, float height, float rx, float ry) {
        this.mRect = new RectF(x, y, x + width, y + height);
        this.mRX = rx;
        this.mRY = ry;
        this.mPath = new Path();
        this.update();
    }

    public RoundRectShape(RoundRectShape rect) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), rect.getRx(), rect.getRy());
        this.mPath = new Path(rect.mPath);
        this.mRegion = new Region(rect.mRegion);
    }

    public Path getPath() {
        return this.mPath;
    }

    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.mPath, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mPath, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawPath(this.mPath, paint);
    }

    public void clip(Canvas canvas) {
        canvas.clipPath(this.mPath);
    }

    public boolean contains(RectShape rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(float x, float y) {
        return this.mRegion.contains((int)x, (int)y);
    }

    public boolean contains(float x, float y, float width, float height) {
        return this.mRegion.contains((int)x, (int)y) && this.mRegion.contains((int)x, (int)(y + height)) && this.mRegion.contains((int)(x + width), (int)y) && this.mRegion.contains((int)(x + width), (int)(y + height));
    }

    public boolean contains(PointF point) {
        return this.mRegion.contains((int)point.x, (int)point.y);
    }

    @Deprecated
    public RectShape getBounds() {
        RectF rect = new RectF();
        this.mPath.computeBounds(rect, false);
        return new RectShape(rect);
    }

    public void getBounds(RectShape rect) {
        this.mPath.computeBounds(this.rectBuffer, false);
        rect.setRectF(this.rectBuffer);
    }

    public boolean intersects(float x, float y, float width, float height) {
        float tmph;
        float tmpy;
        float tmpw;
        float tmpx;
        Region region = new Region(this.mRegion);
        if (x < width + x) {
            tmpx = x;
            tmpw = width;
        } else {
            tmpx = width + x;
            tmpw = Math.abs(width);
        }
        if (y < height + y) {
            tmpy = y;
            tmph = height;
        } else {
            tmpy = height + y;
            tmph = Math.abs(height);
        }
        return region.op((int)tmpx, (int)tmpy, (int)(tmpx + tmpw), (int)(tmpy + tmph), Region.Op.INTERSECT);
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void translate(float x, float y) {
        this.mRect.left += x;
        this.mRect.top += y;
        this.mRect.right += x;
        this.mRect.bottom += y;
    }

    public float getX() {
        return this.mRect.left;
    }

    public void setX(float x) {
        this.mRect.left = x;
    }

    public float getY() {
        return this.mRect.top;
    }

    public void setY(float y) {
        this.mRect.top = y;
    }

    public float getWidth() {
        return this.mRect.width();
    }

    public void setWidth(float width) {
        this.mRect.right = this.getMinX() + width;
    }

    public float getHeight() {
        return this.mRect.height();
    }

    public void setHeight(float height) {
        this.mRect.bottom = this.getMinY() + height;
    }

    public float getRx() {
        return this.mRX;
    }

    public void setRx(float rx) {
        this.mRX = rx;
    }

    public float getRy() {
        return this.mRY;
    }

    public void setRy(float ry) {
        this.mRY = ry;
    }

    public float getMinX() {
        return this.getX();
    }

    public float getMaxX() {
        return this.mRect.right;
    }

    public float getCenterX() {
        return this.mRect.centerX();
    }

    public float getMinY() {
        return this.getY();
    }

    public float getMaxY() {
        return this.mRect.bottom;
    }

    public float getCenterY() {
        return this.mRect.centerY();
    }

    private void update() {
        this.mPath.reset();
        this.mPath.addRoundRect(this.mRect, this.mRX, this.mRY, Path.Direction.CW);
        this.mRegion = new Region((int)this.getMinX(), (int)this.getMinY(), (int)this.getMaxX(), (int)this.getMaxY());
        this.mRegion.setPath(this.mPath, this.mRegion);
    }

    public boolean equals(Object o) {
        if (o instanceof RoundRectShape) {
            RoundRectShape roundRectShape = (RoundRectShape)o;
            if (this.getX() == roundRectShape.getX() && this.getY() == roundRectShape.getY() && this.getWidth() == roundRectShape.getWidth() && this.getHeight() == roundRectShape.getHeight() && this.mRX == roundRectShape.mRX && this.mRY == roundRectShape.mRY) {
                return true;
            }
        }
        return false;
    }

    public RoundRectShape clone() {
        return new RoundRectShape(this);
    }
}

