/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import java.io.Serializable;
import org.afree.chart.renderer.xy.XYBarPainter;
import org.afree.chart.renderer.xy.XYBarRenderer;
import org.afree.graphics.GradientColor;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.RectangleEdge;

public class StandardXYBarPainter
implements XYBarPainter,
Serializable {
    private static final long serialVersionUID = -4208691485399813341L;

    public void paintBar(Canvas canvas, XYBarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base) {
        PaintType itemPaintType = renderer.getItemPaintType(row, column);
        Paint itemPaint = PaintUtility.createPaint(1, itemPaintType);
        if (itemPaintType instanceof GradientColor) {
            GradientShaderFactory t = renderer.getGradientShaderFactory();
            LinearGradient shader = t.create((GradientColor)itemPaintType, bar);
            itemPaint.setShader((Shader)shader);
        }
        canvas.drawRect(bar.getMinX(), bar.getMinY(), bar.getMaxX(), bar.getMaxY(), itemPaint);
        if (renderer.isDrawBarOutline()) {
            float stroke = renderer.getItemOutlineStroke(row, column).floatValue();
            PaintType paintType = renderer.getItemOutlinePaintType(row, column);
            if (stroke != 0.0f && paintType != null) {
                Paint outlinePaint = PaintUtility.createPaint(1, paintType, stroke, renderer.getItemOutlineEffect(row, column));
                canvas.drawRect(bar.getMinX(), bar.getMinY(), bar.getMaxX(), bar.getMaxY(), outlinePaint);
            }
        }
    }

    public void paintBarShadow(Canvas canvas, XYBarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base, boolean pegShadow) {
        PaintType itemPaintType = renderer.getItemPaintType(row, column);
        if (itemPaintType.getAlpha() == 0) {
            return;
        }
        RectShape shadow = this.createShadow(bar, renderer.getShadowXOffset(), renderer.getShadowYOffset(), base, pegShadow);
        Paint paint = PaintUtility.createPaint(1, renderer.getShadowPaintType());
        shadow.fill(canvas, paint);
    }

    private RectShape createShadow(RectShape bar, double xOffset, double yOffset, RectangleEdge base, boolean pegShadow) {
        double x0 = bar.getMinX();
        double x1 = bar.getMaxX();
        double y0 = bar.getMinY();
        double y1 = bar.getMaxY();
        if (base == RectangleEdge.TOP) {
            x0 += xOffset;
            x1 += xOffset;
            if (!pegShadow) {
                y0 += yOffset;
            }
            y1 += yOffset;
        } else if (base == RectangleEdge.BOTTOM) {
            x0 += xOffset;
            x1 += xOffset;
            y0 += yOffset;
            if (!pegShadow) {
                y1 += yOffset;
            }
        } else if (base == RectangleEdge.LEFT) {
            if (!pegShadow) {
                x0 += xOffset;
            }
            x1 += xOffset;
            y0 += yOffset;
            y1 += yOffset;
        } else if (base == RectangleEdge.RIGHT) {
            x0 += xOffset;
            if (!pegShadow) {
                x1 += xOffset;
            }
            y0 += yOffset;
            y1 += yOffset;
        }
        return new RectShape(x0, y0, x1 - x0, y1 - y0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof StandardXYBarPainter;
    }

    public int hashCode() {
        int hash = 37;
        return hash;
    }
}

