/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.data.Range;
import org.afree.data.general.DatasetUtilities;
import org.afree.data.xy.OHLCDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class HighLowRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8135673815876552516L;
    private boolean drawOpenTicks = true;
    private boolean drawCloseTicks = true;
    private transient PaintType openTickPaintType;
    private transient PaintType closeTickPaintType;
    private double tickLength = 2.0;

    public boolean getDrawOpenTicks() {
        return this.drawOpenTicks;
    }

    public void setDrawOpenTicks(boolean draw) {
        this.drawOpenTicks = draw;
    }

    public boolean getDrawCloseTicks() {
        return this.drawCloseTicks;
    }

    public void setDrawCloseTicks(boolean draw) {
        this.drawCloseTicks = draw;
    }

    public PaintType getOpenTickPaintType() {
        return this.openTickPaintType;
    }

    public void setOpenTickPaintType(PaintType paintType) {
        this.openTickPaintType = paintType;
    }

    public PaintType getCloseTickPaintType() {
        return this.closeTickPaintType;
    }

    public void setCloseTickPaintType(PaintType paintType) {
        this.closeTickPaintType = paintType;
    }

    public double getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(double length) {
        this.tickLength = length;
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtilities.findRangeBounds(dataset, true);
        }
        return null;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double x = dataset.getXValue(series, item);
        if (!domainAxis.getRange().contains(x)) {
            return;
        }
        double xx = domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
        RectShape entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge location = plot.getRangeAxisEdge();
        PaintType itemPaintType = this.getItemPaintType(series, item);
        float stroke = this.getItemStroke(series, item).floatValue();
        PathEffect effect = this.getItemEffect(series, item);
        if (dataset instanceof OHLCDataset) {
            double yClose;
            Paint paint;
            PaintType paintType;
            double yOpen;
            OHLCDataset hld = (OHLCDataset)dataset;
            double yHigh = hld.getHighValue(series, item);
            double yLow = hld.getLowValue(series, item);
            if (!Double.isNaN(yHigh) && !Double.isNaN(yLow)) {
                double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, location);
                double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, location);
                Paint itemPaint = PaintUtility.createPaint(1, itemPaintType, stroke, effect);
                if (orientation == PlotOrientation.HORIZONTAL) {
                    new LineShape(yyLow, xx, yyHigh, xx).draw(canvas, itemPaint);
                    entityArea = new RectShape(Math.min(yyLow, yyHigh), xx - 1.0, Math.abs(yyHigh - yyLow), 2.0);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    new LineShape(xx, yyLow, xx, yyHigh).draw(canvas, itemPaint);
                    entityArea = new RectShape(xx - 1.0, Math.min(yyLow, yyHigh), 2.0, Math.abs(yyHigh - yyLow));
                }
            }
            double delta = this.getTickLength();
            if (domainAxis.isInverted()) {
                delta = -delta;
            }
            if (this.getDrawOpenTicks() && !Double.isNaN(yOpen = hld.getOpenValue(series, item))) {
                double yyOpen = rangeAxis.valueToJava2D(yOpen, dataArea, location);
                paintType = this.openTickPaintType != null ? this.openTickPaintType : itemPaintType;
                paint = PaintUtility.createPaint(1, paintType, stroke, effect);
                if (orientation == PlotOrientation.HORIZONTAL) {
                    new LineShape(yyOpen, xx + delta, yyOpen, xx).draw(canvas, paint);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    new LineShape(xx - delta, yyOpen, xx, yyOpen).draw(canvas, paint);
                }
            }
            if (this.getDrawCloseTicks() && !Double.isNaN(yClose = hld.getCloseValue(series, item))) {
                double yyClose = rangeAxis.valueToJava2D(yClose, dataArea, location);
                paintType = this.closeTickPaintType != null ? this.closeTickPaintType : itemPaintType;
                paint = PaintUtility.createPaint(1, paintType, stroke, effect);
                if (orientation == PlotOrientation.HORIZONTAL) {
                    new LineShape(yyClose, xx, yyClose, xx - delta).draw(canvas, paint);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    new LineShape(xx, yyClose, xx + delta, yyClose).draw(canvas, paint);
                }
            }
        } else if (item > 0) {
            double x0 = dataset.getXValue(series, item - 1);
            double y0 = dataset.getYValue(series, item - 1);
            double y = dataset.getYValue(series, item);
            if (Double.isNaN(x0) || Double.isNaN(y0) || Double.isNaN(y)) {
                return;
            }
            double xx0 = domainAxis.valueToJava2D(x0, dataArea, plot.getDomainAxisEdge());
            double yy0 = rangeAxis.valueToJava2D(y0, dataArea, location);
            double yy = rangeAxis.valueToJava2D(y, dataArea, location);
            Paint itemPaint = PaintUtility.createPaint(1, itemPaintType, stroke, effect);
            if (orientation == PlotOrientation.HORIZONTAL) {
                new LineShape(yy0, xx0, yy, xx).draw(canvas, itemPaint);
            } else if (orientation == PlotOrientation.VERTICAL) {
                new LineShape(xx0, yy0, xx, yy).draw(canvas, itemPaint);
            }
        }
        if (entities != null) {
            this.addEntity(entities, entityArea, dataset, series, item, 0.0, 0.0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HighLowRenderer)) {
            return false;
        }
        HighLowRenderer that = (HighLowRenderer)obj;
        if (this.drawOpenTicks != that.drawOpenTicks) {
            return false;
        }
        if (this.drawCloseTicks != that.drawCloseTicks) {
            return false;
        }
        if (this.tickLength != that.tickLength) {
            return false;
        }
        return super.equals(obj);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

