/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.GradientDrawable;
import java.io.Serializable;
import org.afree.chart.renderer.xy.XYBarPainter;
import org.afree.chart.renderer.xy.XYBarRenderer;
import org.afree.graphics.GradientColor;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class GradientXYBarPainter
implements XYBarPainter,
Serializable {
    private static final long serialVersionUID = -8663121191441373564L;
    protected double g1;
    protected double canvas;
    protected double g3;

    public GradientXYBarPainter() {
        this(0.1, 0.2, 0.8);
    }

    public GradientXYBarPainter(double g1, double canvas, double g3) {
        this.g1 = g1;
        this.canvas = canvas;
        this.g3 = g3;
    }

    public void paintBar(Canvas canvas, XYBarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base) {
        GradientDrawable grad;
        int[] color;
        RectShape[] regions;
        PaintType itemPaintType = renderer.getItemPaintType(row, column);
        int c0 = 0;
        int c1 = 0;
        if (itemPaintType instanceof SolidColor) {
            c0 = ((SolidColor)itemPaintType).getColor();
            c1 = Color.rgb((int)Math.min(255, Color.red((int)c0) + 64), (int)Math.min(255, Color.green((int)c0) + 64), (int)Math.min(255, Color.blue((int)c0) + 64));
        } else if (itemPaintType instanceof GradientColor) {
            GradientColor gc = (GradientColor)itemPaintType;
            c0 = gc.getColor1();
            c1 = gc.getColor2();
        } else {
            throw new IllegalArgumentException("Not support PaintType");
        }
        if (itemPaintType.getAlpha() == 0) {
            return;
        }
        if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            regions = this.splitVerticalBar(bar, this.g1, this.canvas, this.g3);
            color = new int[]{c0, -1};
            grad = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, color);
            grad.setSize((int)regions[0].getWidth(), (int)regions[0].getHeight());
            grad.setBounds((int)regions[0].getMinX(), (int)regions[0].getMinY(), (int)regions[0].getMaxX(), (int)regions[0].getMaxY());
            grad.draw(canvas);
            color[0] = -1;
            color[1] = c0;
            grad = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, color);
            grad.setSize((int)regions[1].getWidth(), (int)regions[1].getHeight());
            grad.setBounds((int)regions[1].getMinX(), (int)regions[1].getMinY(), (int)regions[1].getMaxX(), (int)regions[1].getMaxY());
            grad.draw(canvas);
            color[0] = c0;
            color[1] = c1;
            grad = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, color);
            grad.setSize((int)regions[2].getWidth(), (int)regions[2].getHeight());
            grad.setBounds((int)regions[2].getMinX(), (int)regions[2].getMinY(), (int)regions[2].getMaxX(), (int)regions[2].getMaxY());
            grad.draw(canvas);
            color[0] = c1;
            color[1] = c0;
            grad = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, color);
            grad.setSize((int)regions[3].getWidth(), (int)regions[3].getHeight());
            grad.setBounds((int)regions[3].getMinX(), (int)regions[3].getMinY(), (int)regions[3].getMaxX(), (int)regions[3].getMaxY());
            grad.draw(canvas);
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            regions = this.splitHorizontalBar(bar, this.g1, this.canvas, this.g3);
            color = new int[]{c0, -1};
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color);
            grad.setSize((int)regions[0].getWidth(), (int)regions[0].getHeight());
            grad.setBounds((int)regions[0].getMinX(), (int)regions[0].getMinY(), (int)regions[0].getMaxX(), (int)regions[0].getMaxY());
            grad.draw(canvas);
            color[0] = -1;
            color[1] = c0;
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color);
            grad.setSize((int)regions[1].getWidth(), (int)regions[1].getHeight());
            grad.setBounds((int)regions[1].getMinX(), (int)regions[1].getMinY(), (int)regions[1].getMaxX(), (int)regions[1].getMaxY());
            grad.draw(canvas);
            color[0] = c0;
            color[1] = c1;
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color);
            grad.setSize((int)regions[2].getWidth(), (int)regions[2].getHeight());
            grad.setBounds((int)regions[2].getMinX(), (int)regions[2].getMinY(), (int)regions[2].getMaxX(), (int)regions[2].getMaxY());
            grad.draw(canvas);
            color[0] = c1;
            color[1] = c0;
            grad = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, color);
            grad.setSize((int)regions[3].getWidth(), (int)regions[3].getHeight());
            grad.setBounds((int)regions[3].getMinX(), (int)regions[3].getMinY(), (int)regions[3].getMaxX(), (int)regions[3].getMaxY());
            grad.draw(canvas);
        }
        if (renderer.isDrawBarOutline()) {
            float stroke = renderer.getItemOutlineStroke(row, column).floatValue();
            PaintType paintType = renderer.getItemOutlinePaintType(row, column);
            if (stroke != 0.0f && paintType != null) {
                Paint paint = PaintUtility.createPaint(paintType, stroke, renderer.getItemOutlineEffect(row, column));
                canvas.drawRect(bar.getMinX(), bar.getMinY(), bar.getMaxX(), bar.getMaxY(), paint);
            }
        }
    }

    public void paintBarShadow(Canvas canvas, XYBarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base, boolean pegShadow) {
        PaintType itemPaint = renderer.getItemPaintType(row, column);
        if (itemPaint.getAlpha() == 0) {
            return;
        }
        RectShape shadow = this.createShadow(bar, renderer.getShadowXOffset(), renderer.getShadowYOffset(), base, pegShadow);
        Paint paint = PaintUtility.createPaint(1, renderer.getShadowPaintType());
        shadow.fill(canvas, paint);
    }

    private RectShape createShadow(RectShape bar, double xOffset, double yOffset, RectangleEdge base, boolean pegShadow) {
        double x0 = bar.getMinX();
        double x1 = bar.getMaxX();
        double y0 = bar.getMinY();
        double y1 = bar.getMaxY();
        if (base == RectangleEdge.TOP) {
            x0 += xOffset;
            x1 += xOffset;
            if (!pegShadow) {
                y0 += yOffset;
            }
            y1 += yOffset;
        } else if (base == RectangleEdge.BOTTOM) {
            x0 += xOffset;
            x1 += xOffset;
            y0 += yOffset;
            if (!pegShadow) {
                y1 += yOffset;
            }
        } else if (base == RectangleEdge.LEFT) {
            if (!pegShadow) {
                x0 += xOffset;
            }
            x1 += xOffset;
            y0 += yOffset;
            y1 += yOffset;
        } else if (base == RectangleEdge.RIGHT) {
            x0 += xOffset;
            if (!pegShadow) {
                x1 += xOffset;
            }
            y0 += yOffset;
            y1 += yOffset;
        }
        return new RectShape(x0, y0, x1 - x0, y1 - y0);
    }

    protected RectShape[] splitVerticalBar(RectShape bar, double a, double b, double c) {
        RectShape[] result = new RectShape[4];
        double x0 = bar.getMinX();
        double x1 = Math.rint(x0 + (double)bar.getWidth() * a);
        double x2 = Math.rint(x0 + (double)bar.getWidth() * b);
        double x3 = Math.rint(x0 + (double)bar.getWidth() * c);
        result[0] = new RectShape((double)bar.getMinX(), (double)bar.getMinY(), x1 - x0, (double)bar.getHeight());
        result[1] = new RectShape(x1, (double)bar.getMinY(), x2 - x1, (double)bar.getHeight());
        result[2] = new RectShape(x2, (double)bar.getMinY(), x3 - x2, (double)bar.getHeight());
        result[3] = new RectShape(x3, (double)bar.getMinY(), (double)bar.getMaxX() - x3, (double)bar.getHeight());
        return result;
    }

    protected RectShape[] splitHorizontalBar(RectShape bar, double a, double b, double c) {
        RectShape[] result = new RectShape[4];
        double y0 = bar.getMinY();
        double y1 = Math.rint(y0 + (double)bar.getHeight() * a);
        double y2 = Math.rint(y0 + (double)bar.getHeight() * b);
        double y3 = Math.rint(y0 + (double)bar.getHeight() * c);
        result[0] = new RectShape((double)bar.getMinX(), (double)bar.getMinY(), (double)bar.getWidth(), y1 - y0);
        result[1] = new RectShape((double)bar.getMinX(), y1, (double)bar.getWidth(), y2 - y1);
        result[2] = new RectShape((double)bar.getMinX(), y2, (double)bar.getWidth(), y3 - y2);
        result[3] = new RectShape((double)bar.getMinX(), y3, (double)bar.getWidth(), (double)bar.getMaxY() - y3);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GradientXYBarPainter)) {
            return false;
        }
        GradientXYBarPainter that = (GradientXYBarPainter)obj;
        if (this.g1 != that.g1) {
            return false;
        }
        if (this.canvas != that.canvas) {
            return false;
        }
        return this.g3 == that.g3;
    }
}

