/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import org.afree.chart.renderer.category.BarRenderer;
import org.afree.chart.renderer.xy.GradientXYBarPainter;
import org.afree.chart.renderer.xy.XYBarRenderer;
import org.afree.graphics.GradientColor;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.RectangleEdge;

public class AndroidStyleXYBarRenderer
extends GradientXYBarPainter {
    private static final long serialVersionUID = -2643616174344764279L;

    public AndroidStyleXYBarRenderer() {
        this(0.1, 0.2, 0.8);
    }

    public AndroidStyleXYBarRenderer(double g1, double canvas, double g3) {
        super(g1, canvas, g3);
    }

    public void paintBar(Canvas canvas, XYBarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base) {
        PaintType itemPaintType = renderer.getItemPaintType(row, column);
        Paint itemPaint = PaintUtility.createPaint(1, itemPaintType);
        if (itemPaintType instanceof SolidColor) {
            SolidColor col = (SolidColor)itemPaintType;
            itemPaint.setColor(col.getColor());
        } else if (itemPaintType instanceof GradientColor) {
            GradientShaderFactory t = renderer.getGradientShaderFactory();
            LinearGradient shader = t.create((GradientColor)itemPaintType, bar);
            itemPaint.setShader((Shader)shader);
        }
        if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            bar.fill(canvas, itemPaint);
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            bar.fill(canvas, itemPaint);
        }
        if (renderer.isDrawBarOutline()) {
            float stroke = renderer.getItemOutlineStroke(row, column).floatValue();
            PaintType paintType = renderer.getItemOutlinePaintType(row, column);
            if (stroke != 0.0f && paintType != null) {
                Paint paint = PaintUtility.createPaint(1, paintType, stroke, renderer.getItemOutlineEffect(row, column));
                bar.draw(canvas, paint);
            }
        }
    }

    public void paintBarShadow(Canvas canvas, BarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base, boolean pegShadow) {
    }
}

