/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer;

import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import java.io.Serializable;
import org.afree.chart.HashUtilities;
import org.afree.chart.labels.ItemLabelAnchor;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.chart.plot.PlotOrientation;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.TextAnchor;
import org.afree.util.BooleanList;
import org.afree.util.EffectList;
import org.afree.util.ObjectList;
import org.afree.util.ObjectUtilities;
import org.afree.util.PaintTypeList;
import org.afree.util.PaintTypeUtilities;
import org.afree.util.ShapeList;
import org.afree.util.ShapeUtilities;
import org.afree.util.StrokeList;

public abstract class AbstractRenderer
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -828267569428206075L;
    public static final Double ZERO = new Double(0.0);
    public static final PaintType DEFAULT_PAINT = new SolidColor(-16776961);
    public static final PaintType DEFAULT_OUTLINE_PAINT = new SolidColor(-7829368);
    public static final float DEFAULT_STROKE = 1.0f;
    public static final float DEFAULT_OUTLINE_STROKE = 1.0f;
    public static final Shape DEFAULT_SHAPE = new RectShape(-3.0, -3.0, 6.0, 6.0);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_VALUE_LABEL_PAINT = new Paint(1);
    private BooleanList seriesVisibleList = new BooleanList();
    private boolean baseSeriesVisible = true;
    private BooleanList seriesVisibleInLegendList = new BooleanList();
    private boolean baseSeriesVisibleInLegend = true;
    private PaintTypeList paintList = new PaintTypeList();
    private boolean autoPopulateSeriesPaint = true;
    private transient PaintType basePaintType = DEFAULT_PAINT;
    private PaintTypeList fillPaintList = new PaintTypeList();
    private boolean autoPopulateSeriesFillPaint = false;
    private transient PaintType baseFillPaintType = new SolidColor(-1);
    private PaintTypeList outlinePaintList = new PaintTypeList();
    private boolean autoPopulateSeriesOutlinePaint = false;
    private transient PaintType baseOutlinePaintType = DEFAULT_OUTLINE_PAINT;
    private StrokeList strokeList = new StrokeList();
    private EffectList effectList = new EffectList();
    private boolean autoPopulateSeriesStroke = true;
    private boolean autoPopulateSeriesEffect = true;
    private transient float baseStroke = 1.0f;
    private transient PathEffect baseEffect = null;
    private StrokeList outlineStrokeList = new StrokeList();
    private EffectList outlineEffectList = new EffectList();
    private transient float baseOutlineStroke = 1.0f;
    private boolean autoPopulateSeriesOutlineStroke = true;
    private boolean autoPopulateSeriesOutlineEffect = true;
    private ShapeList shapeList = new ShapeList();
    private boolean autoPopulateSeriesShape = true;
    private transient Shape baseShape = DEFAULT_SHAPE;
    private BooleanList itemLabelsVisibleList = new BooleanList();
    private Boolean baseItemLabelsVisible = Boolean.FALSE;
    private ObjectList itemLabelFontList = new ObjectList();
    private Font baseItemLabelFont = new Font("SansSerif", 0, 10);
    private PaintTypeList itemLabelPaintList = new PaintTypeList();
    private transient PaintType baseItemLabelPaintType = new SolidColor(-16777216);
    private ObjectList positiveItemLabelPositionList = new ObjectList();
    private ItemLabelPosition basePositiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
    private ObjectList negativeItemLabelPositionList = new ObjectList();
    private ItemLabelPosition baseNegativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
    private double itemLabelAnchorOffset = 2.0;
    private BooleanList createEntitiesList = new BooleanList();
    private boolean baseCreateEntities = true;
    private ShapeList legendShape = new ShapeList();
    private transient Shape baseLegendShape = null;
    private ObjectList legendTextFont = new ObjectList();
    private Font baseLegendTextFont = null;
    private PaintTypeList legendTextPaint = new PaintTypeList();
    private transient PaintType baseLegendTextPaintType = null;
    private boolean dataBoundsIncludesVisibleSeriesOnly = true;
    private int defaultEntityRadius = 3;
    private static final double ADJ;
    private static final double OPP;

    static {
        DEFAULT_VALUE_LABEL_PAINT.setColor(-16777216);
        ADJ = Math.cos(0.5235987755982988);
        OPP = Math.sin(0.5235987755982988);
    }

    public abstract DrawingSupplier getDrawingSupplier();

    public boolean getItemVisible(int series, int item) {
        return this.isSeriesVisible(series);
    }

    public boolean isSeriesVisible(int series) {
        boolean result = this.baseSeriesVisible;
        Boolean b = this.seriesVisibleList.getBoolean(series);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public Boolean getSeriesVisible(int series) {
        return this.seriesVisibleList.getBoolean(series);
    }

    public void setSeriesVisible(int series, Boolean visible) {
        this.setSeriesVisible(series, visible, true);
    }

    public void setSeriesVisible(int series, Boolean visible, boolean notify) {
        this.seriesVisibleList.setBoolean(series, visible);
    }

    public boolean getBaseSeriesVisible() {
        return this.baseSeriesVisible;
    }

    public void setBaseSeriesVisible(boolean visible) {
        this.setBaseSeriesVisible(visible, true);
    }

    public void setBaseSeriesVisible(boolean visible, boolean notify) {
        this.baseSeriesVisible = visible;
    }

    public boolean isSeriesVisibleInLegend(int series) {
        boolean result = this.baseSeriesVisibleInLegend;
        Boolean b = this.seriesVisibleInLegendList.getBoolean(series);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public Boolean getSeriesVisibleInLegend(int series) {
        return this.seriesVisibleInLegendList.getBoolean(series);
    }

    public void setSeriesVisibleInLegend(int series, Boolean visible) {
        this.setSeriesVisibleInLegend(series, visible, true);
    }

    public void setSeriesVisibleInLegend(int series, Boolean visible, boolean notify) {
        this.seriesVisibleInLegendList.setBoolean(series, visible);
    }

    public boolean getBaseSeriesVisibleInLegend() {
        return this.baseSeriesVisibleInLegend;
    }

    public void setBaseSeriesVisibleInLegend(boolean visible) {
        this.setBaseSeriesVisibleInLegend(visible, true);
    }

    public void setBaseSeriesVisibleInLegend(boolean visible, boolean notify) {
        this.baseSeriesVisibleInLegend = visible;
    }

    public PaintType getItemPaintType(int row, int column) {
        return this.lookupSeriesPaintType(row);
    }

    public PaintType lookupSeriesPaintType(int series) {
        DrawingSupplier supplier;
        PaintType seriesPaint = this.getSeriesPaintType(series);
        if (seriesPaint == null && this.autoPopulateSeriesPaint && (supplier = this.getDrawingSupplier()) != null) {
            seriesPaint = supplier.getNextPaintType();
            this.setSeriesPaintType(series, seriesPaint, false);
        }
        if (seriesPaint == null) {
            seriesPaint = this.basePaintType;
        }
        return seriesPaint;
    }

    public PaintType getSeriesPaintType(int series) {
        return this.paintList.getPaintType(series);
    }

    public void setSeriesPaintType(int series, PaintType paintType) {
        this.setSeriesPaintType(series, paintType, true);
    }

    public void setSeriesPaintType(int series, PaintType paintType, boolean notify) {
        this.paintList.setPaintType(series, paintType);
    }

    public void clearSeriesPaints(boolean notify) {
        this.paintList.clear();
    }

    public PaintType getBasePaintType() {
        return this.basePaintType;
    }

    public void setBasePaintType(PaintType paintType) {
        this.setBasePaintType(paintType, true);
    }

    public void setBasePaintType(PaintType paintType, boolean notify) {
        this.basePaintType = paintType;
    }

    public boolean getAutoPopulateSeriesPaint() {
        return this.autoPopulateSeriesPaint;
    }

    public void setAutoPopulateSeriesPaint(boolean auto) {
        this.autoPopulateSeriesPaint = auto;
    }

    public PaintType getItemFillPaintType(int row, int column) {
        return this.lookupSeriesFillPaintType(row);
    }

    public PaintType lookupSeriesFillPaintType(int series) {
        DrawingSupplier supplier;
        PaintType seriesFillPaintType = this.getSeriesFillPaintType(series);
        if (seriesFillPaintType == null && this.autoPopulateSeriesFillPaint && (supplier = this.getDrawingSupplier()) != null) {
            seriesFillPaintType = supplier.getNextFillPaintType();
            this.setSeriesFillPaintType(series, seriesFillPaintType, false);
        }
        if (seriesFillPaintType == null) {
            seriesFillPaintType = this.baseFillPaintType;
        }
        return seriesFillPaintType;
    }

    public PaintType getSeriesFillPaintType(int series) {
        return this.fillPaintList.getPaintType(series);
    }

    public void setSeriesFillPaintType(int series, PaintType paint) {
        this.setSeriesFillPaintType(series, paint, true);
    }

    public void setSeriesFillPaintType(int series, PaintType paintType, boolean notify) {
        this.fillPaintList.setPaintType(series, paintType);
    }

    public PaintType getBaseFillPaintType() {
        return this.baseFillPaintType;
    }

    public void setBaseFillPaintType(PaintType paintType) {
        this.setBaseFillPaintType(paintType, true);
    }

    public void setBaseFillPaintType(PaintType paintType, boolean notify) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseFillPaintType = paintType;
    }

    public boolean getAutoPopulateSeriesFillPaint() {
        return this.autoPopulateSeriesFillPaint;
    }

    public void setAutoPopulateSeriesFillPaint(boolean auto) {
        this.autoPopulateSeriesFillPaint = auto;
    }

    public PaintType getItemOutlinePaintType(int row, int column) {
        return this.lookupSeriesOutlinePaintType(row);
    }

    public PaintType lookupSeriesOutlinePaintType(int series) {
        DrawingSupplier supplier;
        PaintType seriesOutlinePaintType = this.getSeriesOutlinePaintType(series);
        if (seriesOutlinePaintType == null && this.autoPopulateSeriesOutlinePaint && (supplier = this.getDrawingSupplier()) != null) {
            seriesOutlinePaintType = supplier.getNextOutlinePaintType();
            this.setSeriesOutlinePaintType(series, seriesOutlinePaintType, false);
        }
        if (seriesOutlinePaintType == null) {
            seriesOutlinePaintType = this.baseOutlinePaintType;
        }
        return seriesOutlinePaintType;
    }

    public PaintType getSeriesOutlinePaintType(int series) {
        return this.outlinePaintList.getPaintType(series);
    }

    public void setSeriesOutlinePaintType(int series, PaintType paintType) {
        this.setSeriesOutlinePaintType(series, paintType, true);
    }

    public void setSeriesOutlinePaintType(int series, PaintType paintType, boolean notify) {
        this.outlinePaintList.setPaintType(series, paintType);
    }

    public PaintType getBaseOutlinePaintType() {
        return this.baseOutlinePaintType;
    }

    public void setBaseOutlinePaintType(PaintType paintType) {
        this.setBaseOutlinePaintType(paintType, true);
    }

    public void setBaseOutlinePaintType(PaintType paintType, boolean notify) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseOutlinePaintType = paintType;
    }

    public boolean getAutoPopulateSeriesOutlinePaint() {
        return this.autoPopulateSeriesOutlinePaint;
    }

    public void setAutoPopulateSeriesOutlinePaint(boolean auto) {
        this.autoPopulateSeriesOutlinePaint = auto;
    }

    public Float getItemStroke(int row, int column) {
        return Float.valueOf(this.lookupSeriesStroke(row));
    }

    public PathEffect getItemEffect(int row, int column) {
        return this.lookupSeriesEffect(row);
    }

    public float lookupSeriesStroke(int series) {
        DrawingSupplier supplier;
        Float result = this.getSeriesStroke(series);
        if (result == null && this.autoPopulateSeriesStroke && (supplier = this.getDrawingSupplier()) != null) {
            result = Float.valueOf(supplier.getNextStroke());
            this.setSeriesStroke(series, result.floatValue(), false);
        }
        if (result == null) {
            result = Float.valueOf(this.baseStroke);
        }
        return result.floatValue();
    }

    public PathEffect lookupSeriesEffect(int series) {
        DrawingSupplier supplier;
        PathEffect result = this.getSeriesEffect(series);
        if (result == null && this.autoPopulateSeriesEffect && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextEffect();
            this.setSeriesEffect(series, result, false);
        }
        if (result == null) {
            result = this.baseEffect;
        }
        return result;
    }

    public Float getSeriesStroke(int series) {
        return this.strokeList.getStroke(series);
    }

    public PathEffect getSeriesEffect(int series) {
        return this.effectList.getEffect(series);
    }

    public void setSeriesStroke(int series, Float stroke) {
        this.setSeriesStroke(series, stroke.floatValue(), true);
    }

    public void setSeriesStroke(int series, float stroke, boolean notify) {
        this.strokeList.setStroke(series, stroke);
    }

    public void setSeriesEffect(int series, PathEffect effect, boolean notify) {
        this.effectList.setEffect(series, effect);
    }

    public void clearSeriesStrokes(boolean notify) {
        this.strokeList.clear();
    }

    public Float getBaseStroke() {
        return Float.valueOf(this.baseStroke);
    }

    public void setBaseStroke(float stroke) {
        this.setBaseStroke(stroke, true);
    }

    public void setBaseStroke(Float stroke) {
        this.setBaseStroke(stroke.floatValue(), true);
    }

    public void setBaseStroke(float stroke, boolean notify) {
        this.baseStroke = stroke;
    }

    public boolean getAutoPopulateSeriesStroke() {
        return this.autoPopulateSeriesStroke;
    }

    public void setAutoPopulateSeriesStroke(boolean auto) {
        this.autoPopulateSeriesStroke = auto;
    }

    public Float getItemOutlineStroke(int row, int column) {
        return this.lookupSeriesOutlineStroke(row);
    }

    public Float lookupSeriesOutlineStroke(int series) {
        DrawingSupplier supplier;
        float result = this.getSeriesOutlineStroke(series).floatValue();
        if (this.autoPopulateSeriesOutlineStroke && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextOutlineStroke();
            this.setSeriesOutlineStroke(series, result, false);
        }
        return Float.valueOf(result);
    }

    public PathEffect getSeriesOutlineEffect(int series) {
        return this.outlineEffectList.getEffect(series);
    }

    public PathEffect getItemOutlineEffect(int row, int column) {
        return this.lookupSeriesOutlineEffect(row);
    }

    public PathEffect lookupSeriesOutlineEffect(int series) {
        DrawingSupplier supplier;
        PathEffect result = this.getSeriesOutlineEffect(series);
        if (this.autoPopulateSeriesOutlineEffect && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextOutlineEffect();
            this.setSeriesOutlineEffect(series, result, false);
        }
        return result;
    }

    public Float getSeriesOutlineStroke(int series) {
        return Float.valueOf(this.outlineStrokeList.getStroke(series) == null ? 1.0f : this.outlineStrokeList.getStroke(series).floatValue());
    }

    public void setSeriesOutlineStroke(int series, Float stroke) {
        this.setSeriesOutlineStroke(series, stroke.floatValue(), true);
    }

    public void setSeriesOutlineStroke(int series, float stroke, boolean notify) {
        this.outlineStrokeList.setStroke(series, stroke);
    }

    public void setSeriesOutlineEffect(int series, PathEffect effect) {
        this.setSeriesOutlineEffect(series, effect, true);
    }

    public void setSeriesOutlineEffect(int series, PathEffect effect, boolean notify) {
        this.outlineEffectList.setEffect(series, effect);
    }

    public Float getBaseOutlineStroke() {
        return Float.valueOf(this.baseOutlineStroke);
    }

    public void setBaseOutlineStroke(Float stroke) {
        this.setBaseOutlineStroke(stroke, true);
    }

    public void setBaseOutlineStroke(Float stroke, boolean notify) {
        this.baseOutlineStroke = stroke.floatValue();
    }

    public boolean getAutoPopulateSeriesOutlineStroke() {
        return this.autoPopulateSeriesOutlineStroke;
    }

    public void setAutoPopulateSeriesOutlineStroke(boolean auto) {
        this.autoPopulateSeriesOutlineStroke = auto;
    }

    public boolean getAutoPopulateSeriesOutlineEffect() {
        return this.autoPopulateSeriesOutlineEffect;
    }

    public void setAutoPopulateSeriesOutlineEffect(boolean auto) {
        this.autoPopulateSeriesOutlineEffect = auto;
    }

    public Shape getItemShape(int row, int column) {
        return this.lookupSeriesShape(row);
    }

    public Shape lookupSeriesShape(int series) {
        DrawingSupplier supplier;
        Shape result = this.getSeriesShape(series);
        if (result == null && this.autoPopulateSeriesShape && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextShape();
            this.setSeriesShape(series, result, false);
        }
        if (result == null) {
            result = this.baseShape;
        }
        return result;
    }

    public Shape getSeriesShape(int series) {
        return this.shapeList.getShape(series);
    }

    public void setSeriesShape(int series, Shape shape) {
        this.setSeriesShape(series, shape, true);
    }

    public void setSeriesShape(int series, Shape shape, boolean notify) {
        this.shapeList.setShape(series, shape);
    }

    public Shape getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Shape shape) {
        this.setBaseShape(shape, true);
    }

    public void setBaseShape(Shape shape, boolean notify) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.baseShape = shape;
    }

    public boolean getAutoPopulateSeriesShape() {
        return this.autoPopulateSeriesShape;
    }

    public void setAutoPopulateSeriesShape(boolean auto) {
        this.autoPopulateSeriesShape = auto;
    }

    public boolean isItemLabelVisible(int row, int column) {
        return this.isSeriesItemLabelsVisible(row);
    }

    public boolean isSeriesItemLabelsVisible(int series) {
        Boolean b = this.itemLabelsVisibleList.getBoolean(series);
        if (b == null) {
            b = this.baseItemLabelsVisible;
        }
        if (b == null) {
            b = Boolean.FALSE;
        }
        return b;
    }

    public void setSeriesItemLabelsVisible(int series, boolean visible) {
        this.setSeriesItemLabelsVisible(series, (Boolean)visible);
    }

    public void setSeriesItemLabelsVisible(int series, Boolean visible) {
        this.setSeriesItemLabelsVisible(series, visible, true);
    }

    public void setSeriesItemLabelsVisible(int series, Boolean visible, boolean notify) {
        this.itemLabelsVisibleList.setBoolean(series, visible);
    }

    public Boolean getBaseItemLabelsVisible() {
        return this.baseItemLabelsVisible;
    }

    public void setBaseItemLabelsVisible(boolean visible) {
        this.setBaseItemLabelsVisible((Boolean)visible);
    }

    public void setBaseItemLabelsVisible(Boolean visible) {
        this.setBaseItemLabelsVisible(visible, true);
    }

    public void setBaseItemLabelsVisible(Boolean visible, boolean notify) {
        this.baseItemLabelsVisible = visible;
    }

    public Font getItemLabelFont(int row, int column) {
        Font result = null;
        result = this.getSeriesItemLabelFont(row);
        if (result == null) {
            result = this.baseItemLabelFont;
        }
        return result;
    }

    public Font getSeriesItemLabelFont(int series) {
        return (Font)this.itemLabelFontList.get(series);
    }

    public void setSeriesItemLabelFont(int series, Font font) {
        this.setSeriesItemLabelFont(series, font, true);
    }

    public void setSeriesItemLabelFont(int series, Font font, boolean notify) {
        this.itemLabelFontList.set(series, font);
    }

    public Font getBaseItemLabelFont() {
        return this.baseItemLabelFont;
    }

    public void setBaseItemLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.setBaseItemLabelFont(font, true);
    }

    public void setBaseItemLabelFont(Font font, boolean notify) {
        this.baseItemLabelFont = font;
    }

    public PaintType getItemLabelPaintType(int row, int column) {
        PaintType result = null;
        result = this.getSeriesItemLabelPaintType(row);
        if (result == null) {
            result = this.baseItemLabelPaintType;
        }
        return result;
    }

    public PaintType getSeriesItemLabelPaintType(int series) {
        return this.itemLabelPaintList.getPaintType(series);
    }

    public void setSeriesItemLabelPaintType(int series, PaintType paintType) {
        this.setSeriesItemLabelPaintTypeType(series, paintType, true);
    }

    public void setSeriesItemLabelPaintTypeType(int series, PaintType paintType, boolean notify) {
        this.itemLabelPaintList.setPaintType(series, paintType);
    }

    public PaintType getBaseItemLabelPaintType() {
        return this.baseItemLabelPaintType;
    }

    public void setBaseItemLabelPaintType(PaintType paintType) {
        this.setBaseItemLabelPaintType(paintType, true);
    }

    public void setBaseItemLabelPaintType(PaintType paintType, boolean notify) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseItemLabelPaintType = paintType;
    }

    public ItemLabelPosition getPositiveItemLabelPosition(int row, int column) {
        return this.getSeriesPositiveItemLabelPosition(row);
    }

    public ItemLabelPosition getSeriesPositiveItemLabelPosition(int series) {
        ItemLabelPosition position = (ItemLabelPosition)this.positiveItemLabelPositionList.get(series);
        if (position == null) {
            position = this.basePositiveItemLabelPosition;
        }
        return position;
    }

    public void setSeriesPositiveItemLabelPosition(int series, ItemLabelPosition position) {
        this.setSeriesPositiveItemLabelPosition(series, position, true);
    }

    public void setSeriesPositiveItemLabelPosition(int series, ItemLabelPosition position, boolean notify) {
        this.positiveItemLabelPositionList.set(series, position);
    }

    public ItemLabelPosition getBasePositiveItemLabelPosition() {
        return this.basePositiveItemLabelPosition;
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition position) {
        this.setBasePositiveItemLabelPosition(position, true);
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition position, boolean notify) {
        if (position == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.basePositiveItemLabelPosition = position;
    }

    public ItemLabelPosition getNegativeItemLabelPosition(int row, int column) {
        return this.getSeriesNegativeItemLabelPosition(row);
    }

    public ItemLabelPosition getSeriesNegativeItemLabelPosition(int series) {
        ItemLabelPosition position = (ItemLabelPosition)this.negativeItemLabelPositionList.get(series);
        if (position == null) {
            position = this.baseNegativeItemLabelPosition;
        }
        return position;
    }

    public void setSeriesNegativeItemLabelPosition(int series, ItemLabelPosition position) {
        this.setSeriesNegativeItemLabelPosition(series, position, true);
    }

    public void setSeriesNegativeItemLabelPosition(int series, ItemLabelPosition position, boolean notify) {
        this.negativeItemLabelPositionList.set(series, position);
    }

    public ItemLabelPosition getBaseNegativeItemLabelPosition() {
        return this.baseNegativeItemLabelPosition;
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition position) {
        this.setBaseNegativeItemLabelPosition(position, true);
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition position, boolean notify) {
        if (position == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.baseNegativeItemLabelPosition = position;
    }

    public double getItemLabelAnchorOffset() {
        return this.itemLabelAnchorOffset;
    }

    public void setItemLabelAnchorOffset(double offset) {
        this.itemLabelAnchorOffset = offset;
    }

    public boolean getItemCreateEntity(int series, int item) {
        Boolean b = this.getSeriesCreateEntities(series);
        if (b != null) {
            return b;
        }
        return this.baseCreateEntities;
    }

    public Boolean getSeriesCreateEntities(int series) {
        return this.createEntitiesList.getBoolean(series);
    }

    public void setSeriesCreateEntities(int series, Boolean create) {
        this.setSeriesCreateEntities(series, create, true);
    }

    public void setSeriesCreateEntities(int series, Boolean create, boolean notify) {
        this.createEntitiesList.setBoolean(series, create);
    }

    public boolean getBaseCreateEntities() {
        return this.baseCreateEntities;
    }

    public void setBaseCreateEntities(boolean create) {
        this.setBaseCreateEntities(create, true);
    }

    public void setBaseCreateEntities(boolean create, boolean notify) {
        this.baseCreateEntities = create;
    }

    public int getDefaultEntityRadius() {
        return this.defaultEntityRadius;
    }

    public void setDefaultEntityRadius(int radius) {
        this.defaultEntityRadius = radius;
    }

    public Shape lookupLegendShape(int series) {
        Shape result = this.getLegendShape(series);
        if (result == null) {
            result = this.baseLegendShape;
        }
        if (result == null) {
            result = this.lookupSeriesShape(series);
        }
        return result;
    }

    public Shape getLegendShape(int series) {
        return this.legendShape.getShape(series);
    }

    public void setLegendShape(int series, Shape shape) {
        this.legendShape.setShape(series, shape);
    }

    public Shape getBaseLegendShape() {
        return this.baseLegendShape;
    }

    public void setBaseLegendShape(Shape shape) {
        this.baseLegendShape = shape;
    }

    public Font lookupLegendTextFont(int series) {
        Font result = this.getLegendTextFont(series);
        if (result == null) {
            result = this.baseLegendTextFont;
        }
        return result;
    }

    public Font getLegendTextFont(int series) {
        return (Font)this.legendTextFont.get(series);
    }

    public void setLegendTextFont(int series, Font font) {
        this.legendTextFont.set(series, font);
    }

    public Font getBaseLegendTextFont() {
        return this.baseLegendTextFont;
    }

    public void setBaseLegendTextFont(Font font) {
        this.baseLegendTextFont = font;
    }

    public PaintType lookupLegendTextPaintType(int series) {
        PaintType result = this.getLegendTextPaint(series);
        if (result == null) {
            result = this.baseLegendTextPaintType;
        }
        return result;
    }

    public PaintType getLegendTextPaint(int series) {
        return this.legendTextPaint.getPaintType(series);
    }

    public void setLegendTextPaintType(int series, PaintType paintType) {
        this.legendTextPaint.setPaintType(series, paintType);
    }

    public PaintType getBaseLegendTextPaintType() {
        return this.baseLegendTextPaintType;
    }

    public void setBaseLegendTextPaintType(PaintType paintType) {
        this.baseLegendTextPaintType = paintType;
    }

    public boolean getDataBoundsIncludesVisibleSeriesOnly() {
        return this.dataBoundsIncludesVisibleSeriesOnly;
    }

    public void setDataBoundsIncludesVisibleSeriesOnly(boolean visibleOnly) {
        this.dataBoundsIncludesVisibleSeriesOnly = visibleOnly;
    }

    protected PointF calculateLabelAnchorPoint(ItemLabelAnchor anchor, double x, double y, PlotOrientation orientation) {
        PointF result = null;
        if (anchor == ItemLabelAnchor.CENTER) {
            result = new PointF((float)x, (float)y);
        } else if (anchor == ItemLabelAnchor.INSIDE1) {
            result = new PointF((float)(x + OPP * this.itemLabelAnchorOffset), (float)(y - ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE2) {
            result = new PointF((float)(x + ADJ * this.itemLabelAnchorOffset), (float)(y - OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE3) {
            result = new PointF((float)(x + this.itemLabelAnchorOffset), (float)y);
        } else if (anchor == ItemLabelAnchor.INSIDE4) {
            result = new PointF((float)(x + ADJ * this.itemLabelAnchorOffset), (float)(y + OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE5) {
            result = new PointF((float)(x + OPP * this.itemLabelAnchorOffset), (float)(y + ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE6) {
            result = new PointF((float)x, (float)(y + this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE7) {
            result = new PointF((float)(x - OPP * this.itemLabelAnchorOffset), (float)(y + ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE8) {
            result = new PointF((float)(x - ADJ * this.itemLabelAnchorOffset), (float)(y + OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE9) {
            result = new PointF((float)(x - this.itemLabelAnchorOffset), (float)y);
        } else if (anchor == ItemLabelAnchor.INSIDE10) {
            result = new PointF((float)(x - ADJ * this.itemLabelAnchorOffset), (float)(y - OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE11) {
            result = new PointF((float)(x - OPP * this.itemLabelAnchorOffset), (float)(y - ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.INSIDE12) {
            result = new PointF((float)x, (float)(y - this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE1) {
            result = new PointF((float)(x + 2.0 * OPP * this.itemLabelAnchorOffset), (float)(y - 2.0 * ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE2) {
            result = new PointF((float)(x + 2.0 * ADJ * this.itemLabelAnchorOffset), (float)(y - 2.0 * OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE3) {
            result = new PointF((float)(x + 2.0 * this.itemLabelAnchorOffset), (float)y);
        } else if (anchor == ItemLabelAnchor.OUTSIDE4) {
            result = new PointF((float)(x + 2.0 * ADJ * this.itemLabelAnchorOffset), (float)(y + 2.0 * OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE5) {
            result = new PointF((float)(x + 2.0 * OPP * this.itemLabelAnchorOffset), (float)(y + 2.0 * ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE6) {
            result = new PointF((float)x, (float)(y + 2.0 * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE7) {
            result = new PointF((float)(x - 2.0 * OPP * this.itemLabelAnchorOffset), (float)(y + 2.0 * ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE8) {
            result = new PointF((float)(x - 2.0 * ADJ * this.itemLabelAnchorOffset), (float)(y + 2.0 * OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE9) {
            result = new PointF((float)(x - 2.0 * this.itemLabelAnchorOffset), (float)y);
        } else if (anchor == ItemLabelAnchor.OUTSIDE10) {
            result = new PointF((float)(x - 2.0 * ADJ * this.itemLabelAnchorOffset), (float)(y - 2.0 * OPP * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE11) {
            result = new PointF((float)(x - 2.0 * OPP * this.itemLabelAnchorOffset), (float)(y - 2.0 * ADJ * this.itemLabelAnchorOffset));
        } else if (anchor == ItemLabelAnchor.OUTSIDE12) {
            result = new PointF((float)x, (float)(y - 2.0 * this.itemLabelAnchorOffset));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractRenderer)) {
            return false;
        }
        AbstractRenderer that = (AbstractRenderer)obj;
        if (this.dataBoundsIncludesVisibleSeriesOnly != that.dataBoundsIncludesVisibleSeriesOnly) {
            return false;
        }
        if (this.defaultEntityRadius != that.defaultEntityRadius) {
            return false;
        }
        if (!this.seriesVisibleList.equals(that.seriesVisibleList)) {
            return false;
        }
        if (this.baseSeriesVisible != that.baseSeriesVisible) {
            return false;
        }
        if (!this.seriesVisibleInLegendList.equals(that.seriesVisibleInLegendList)) {
            return false;
        }
        if (this.baseSeriesVisibleInLegend != that.baseSeriesVisibleInLegend) {
            return false;
        }
        if (!ObjectUtilities.equal(this.paintList, that.paintList)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.basePaintType, that.basePaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fillPaintList, that.fillPaintList)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.baseFillPaintType, that.baseFillPaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlinePaintList, that.outlinePaintList)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.baseOutlinePaintType, that.baseOutlinePaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.strokeList, that.strokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.baseStroke), Float.valueOf(that.baseStroke))) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStrokeList, that.outlineStrokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.baseOutlineStroke), Float.valueOf(that.baseOutlineStroke))) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapeList, that.shapeList)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.baseShape, that.baseShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelsVisibleList, that.itemLabelsVisibleList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelsVisible, that.baseItemLabelsVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelFontList, that.itemLabelFontList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelFont, that.baseItemLabelFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelPaintList, that.itemLabelPaintList)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.baseItemLabelPaintType, that.baseItemLabelPaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionList, that.positiveItemLabelPositionList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.basePositiveItemLabelPosition, that.basePositiveItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPositionList, that.negativeItemLabelPositionList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseNegativeItemLabelPosition, that.baseNegativeItemLabelPosition)) {
            return false;
        }
        if (this.itemLabelAnchorOffset != that.itemLabelAnchorOffset) {
            return false;
        }
        if (!ObjectUtilities.equal(this.createEntitiesList, that.createEntitiesList)) {
            return false;
        }
        if (this.baseCreateEntities != that.baseCreateEntities) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendShape, that.legendShape)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.baseLegendShape, that.baseLegendShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendTextFont, that.legendTextFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseLegendTextFont, that.baseLegendTextFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendTextPaint, that.legendTextPaint)) {
            return false;
        }
        return PaintTypeUtilities.equal(this.baseLegendTextPaintType, that.baseLegendTextPaintType);
    }

    public int hashCode() {
        int result = 193;
        result = HashUtilities.hashCode(result, this.seriesVisibleList);
        result = HashUtilities.hashCode(result, this.baseSeriesVisible);
        result = HashUtilities.hashCode(result, this.seriesVisibleInLegendList);
        result = HashUtilities.hashCode(result, this.baseSeriesVisibleInLegend);
        result = HashUtilities.hashCode(result, this.paintList);
        result = HashUtilities.hashCode(result, this.basePaintType);
        result = HashUtilities.hashCode(result, this.fillPaintList);
        result = HashUtilities.hashCode(result, this.baseFillPaintType);
        result = HashUtilities.hashCode(result, this.outlinePaintList);
        result = HashUtilities.hashCode(result, this.baseOutlinePaintType);
        result = HashUtilities.hashCode(result, this.strokeList);
        result = HashUtilities.hashCode(result, this.baseStroke);
        result = HashUtilities.hashCode(result, this.outlineStrokeList);
        result = HashUtilities.hashCode(result, this.baseOutlineStroke);
        result = HashUtilities.hashCode(result, this.itemLabelsVisibleList);
        result = HashUtilities.hashCode(result, this.baseItemLabelsVisible);
        return result;
    }
}

