/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.PointF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.afree.chart.ChartRenderingInfo;
import org.afree.graphics.geom.RectShape;
import org.afree.util.ObjectUtilities;

public class PlotRenderingInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8446720134379617220L;
    private ChartRenderingInfo owner;
    private transient RectShape plotArea;
    private transient RectShape dataArea;
    private List subplotInfo;

    public PlotRenderingInfo(ChartRenderingInfo owner) {
        this.owner = owner;
        this.dataArea = new RectShape();
        this.subplotInfo = new ArrayList();
    }

    public ChartRenderingInfo getOwner() {
        return this.owner;
    }

    public RectShape getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(RectShape area) {
        this.plotArea = area;
    }

    public RectShape getDataArea() {
        return this.dataArea;
    }

    public void setDataArea(RectShape area) {
        this.dataArea = area;
    }

    public int getSubplotCount() {
        return this.subplotInfo.size();
    }

    public void addSubplotInfo(PlotRenderingInfo info) {
        this.subplotInfo.add(info);
    }

    public PlotRenderingInfo getSubplotInfo(int index) {
        return (PlotRenderingInfo)this.subplotInfo.get(index);
    }

    public int getSubplotIndex(PointF source) {
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        int subplotCount = this.getSubplotCount();
        int i = 0;
        while (i < subplotCount) {
            PlotRenderingInfo info = this.getSubplotInfo(i);
            RectShape area = info.getDataArea();
            if (area.contains(source)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlotRenderingInfo)) {
            return false;
        }
        PlotRenderingInfo that = (PlotRenderingInfo)obj;
        if (!ObjectUtilities.equal(this.dataArea, that.dataArea)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.plotArea, that.plotArea)) {
            return false;
        }
        return ObjectUtilities.equal(this.subplotInfo, that.subplotInfo);
    }

    public Object clone() throws CloneNotSupportedException {
        PlotRenderingInfo clone = (PlotRenderingInfo)super.clone();
        if (this.plotArea != null) {
            clone.plotArea = this.plotArea.clone();
        }
        if (this.dataArea != null) {
            clone.dataArea = this.dataArea.clone();
        }
        clone.subplotInfo = new ArrayList(this.subplotInfo.size());
        int i = 0;
        while (i < this.subplotInfo.size()) {
            PlotRenderingInfo info = (PlotRenderingInfo)this.subplotInfo.get(i);
            clone.subplotInfo.add(info.clone());
            ++i;
        }
        return clone;
    }
}

